/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator;

import com.microej.converter.vectorimage.InvalidOutputException;
import com.microej.converter.vectorimage.Logger;
import com.microej.converter.vectorimage.ShapeUtils;
import com.microej.converter.vectorimage.generator.AbstractGenerator;
import com.microej.converter.vectorimage.vg.VGAnimation;
import com.microej.converter.vectorimage.vg.VGGradient;
import com.microej.converter.vectorimage.vg.VGGroup;
import com.microej.converter.vectorimage.vg.VGGroupAnimate;
import com.microej.converter.vectorimage.vg.VGGroupTransform;
import com.microej.converter.vectorimage.vg.VGPath;
import com.microej.converter.vectorimage.vg.VGRotateAnimation;
import com.microej.converter.vectorimage.vg.VGScaleAnimation;
import com.microej.converter.vectorimage.vg.VGStyle;
import com.microej.converter.vectorimage.vg.VGTranslateAnimation;
import com.microej.converter.vectorimage.vg.VGUtils;
import ej.microvg.image.LinearGradient;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgGenerator
extends AbstractGenerator {
    private static final String SVG_SVG_ELEMENT = "svg";
    private static final String SVG_GROUP_ELEMENT = "g";
    private static final String SVG_PATH_ELEMENT = "path";
    private static final String SVG_DEFS_ELEMENT = "defs";
    private static final String SVG_GRADIENT_ELEMENT = "linearGradient";
    private static final String SVG_STOP_ELEMENT = "stop";
    private static final String SVG_ANIMATETRANSFORM_ELEMENT = "animateTransform";
    private static final String SVG_WIDTH = "width";
    private static final String SVG_HEIGHT = "height";
    private static final String SVG_VIEWBOX = "viewBox";
    private static final String SVG_VERSION = "version";
    private static final String SVG_XMLNS = "xmlns";
    private static final String SVG_XMLNS_URL = "http://www.w3.org/2000/svg";
    private static final String SVG_D = "d";
    private static final String SVG_XMLID = "xml:id";
    private static final String SVG_FILL = "fill";
    private static final String SVG_FILL_OPACITY = "fill-opacity";
    private static final String SVG_TRANSFORM = "transform";
    private static final String SVG_FILLRULE = "fill-rule";
    private static final String SVG_FILLRULE_NONZERO = "nonzero";
    private static final String SVG_FILLRULE_EVENODD = "evenodd";
    private static final String SVG_GRADIENT_ID = "id";
    private static final String SVG_GRADIENT_STARTX = "x1";
    private static final String SVG_GRADIENT_STARTY = "y1";
    private static final String SVG_GRADIENT_ENDX = "x2";
    private static final String SVG_GRADIENT_ENDY = "y2";
    private static final String SVG_GRADIENT_GRADIENTUNITS = "gradientUnits";
    private static final String SVG_GRADIENT_GRADIENTUNITS_USERSPACEONUSE = "userSpaceOnUse";
    private static final String SVG_GRADIENT_COLOR = "stop-color";
    private static final String SVG_GRADIENT_OPACITY = "stop-opacity";
    private static final String SVG_GRADIENT_OFFSET = "offset";
    private static final String SVG_TRANSFORM_ORIGIN = "transform-origin";
    private final int decimalDigits;
    private final String imageName;
    private final File outputFile;
    private Document doc;
    private Element svg;
    private Element defs;
    private Element currentParent;
    private AffineTransform currentTransform;

    public SvgGenerator(String outputFolder, String outputName, String imageName, int decimalDigits) {
        this.imageName = imageName;
        this.decimalDigits = decimalDigits;
        this.outputFile = SvgGenerator.getOutputFile(outputFolder, outputName);
        File parentFolder = this.outputFile.getParentFile();
        if (!parentFolder.exists() && !parentFolder.mkdirs()) {
            throw new InvalidOutputException("Invalid output parameters. " + this.outputFile.getAbsolutePath() + " cannot be written.");
        }
    }

    private static File getOutputFile(String outputFolder, String outputName) {
        if (outputFolder == null) {
            outputFolder = System.getProperty("user.dir");
        }
        String path = String.valueOf(outputFolder) + File.separatorChar + outputName;
        return new File(path);
    }

    @Override
    public void init(float width, float height, boolean hasOverlappingPaths, boolean hierarchical) throws Exception {
        super.init(width, height, hasOverlappingPaths, hierarchical);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
        this.svg = this.doc.createElement(SVG_SVG_ELEMENT);
        this.svg.setAttribute(SVG_WIDTH, String.valueOf(Float.toString(width)) + "dp");
        this.svg.setAttribute(SVG_HEIGHT, String.valueOf(Float.toString(height)) + "dp");
        String viewBox = "0 0 " + Float.toString(width) + " " + Float.toString(height);
        this.svg.setAttribute(SVG_VIEWBOX, viewBox);
        this.svg.setAttribute(SVG_VERSION, "1.1");
        this.svg.setAttribute(SVG_XMLNS, SVG_XMLNS_URL);
        this.defs = this.doc.createElement(SVG_DEFS_ELEMENT);
        this.currentParent = this.svg;
        this.currentTransform = new AffineTransform();
    }

    private int convertColor(Color color) {
        int newColor = 0;
        newColor |= color.getRed() << 16;
        newColor |= color.getGreen() << 8;
        return newColor |= color.getBlue();
    }

    private String convertFillRule(boolean fillRule) {
        if (fillRule) {
            return SVG_FILLRULE_EVENODD;
        }
        return SVG_FILLRULE_NONZERO;
    }

    private String getHexa(int fill) {
        return String.format("#%06X", fill);
    }

    @Override
    public void end() throws Exception {
        if (this.defs.hasChildNodes()) {
            this.svg.insertBefore(this.defs, this.svg.getFirstChild());
        }
        Comment comment = this.doc.createComment("microej:version=\"" + System.getProperty("vectorimage-converter.version") + "\" microej:imageName=\"" + this.imageName + "\"");
        this.svg.insertBefore(comment, this.svg.getFirstChild());
        this.doc.appendChild(this.svg);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        DOMSource source = new DOMSource(this.doc);
        StreamResult result = new StreamResult(this.outputFile.getPath());
        transformer.transform(source, result);
        Logger.logString("SVG file generated: " + this.outputFile.getAbsolutePath());
    }

    @Override
    public void print(VGGroup vgGroup) throws Exception {
        Element previousParent = this.currentParent;
        AffineTransform previousTransform = this.currentTransform;
        Element groupElement = null;
        this.currentTransform = new AffineTransform(this.currentTransform);
        if (vgGroup instanceof VGGroupTransform) {
            this.currentTransform.concatenate(((VGGroupTransform)vgGroup).getTransformation());
        }
        if (this.isHierarchical()) {
            groupElement = this.doc.createElement(SVG_GROUP_ELEMENT);
            if (vgGroup.getName() != null && !vgGroup.getName().equals("")) {
                AffineTransform groupAt;
                groupElement.setAttribute(SVG_XMLID, vgGroup.getName());
                if (vgGroup instanceof VGGroupTransform && !(groupAt = ((VGGroupTransform)vgGroup).getTransformation()).isIdentity()) {
                    String matrix = "matrix(" + groupAt.getScaleX() + " " + groupAt.getShearY() + " " + groupAt.getShearX() + " " + groupAt.getScaleY() + " " + groupAt.getTranslateX() + " " + groupAt.getTranslateY() + ")";
                    groupElement.setAttribute(SVG_TRANSFORM, matrix);
                }
            }
            this.currentParent.appendChild(groupElement);
            if (vgGroup instanceof VGGroupAnimate) {
                groupElement = this.printAnimations((VGGroupAnimate)vgGroup, groupElement);
            }
        } else {
            groupElement = this.currentParent;
        }
        this.currentParent = groupElement;
        super.print(vgGroup);
        this.currentParent = previousParent;
        this.currentTransform = previousTransform;
    }

    @Override
    public void print(VGPath vgPath) throws Exception {
        String pathData = vgPath.getPathData();
        if (!this.isHierarchical()) {
            Shape transformedShape = this.currentTransform.createTransformedShape(ShapeUtils.getPathShape(pathData));
            pathData = ShapeUtils.getPathString(transformedShape);
        }
        this.printPath(this.currentParent, vgPath.getName(), pathData, vgPath.getStyle(), this.currentTransform);
    }

    private void printPath(Element svgParent, String name, String pathData, VGStyle style, AffineTransform at) {
        if (pathData.equals("")) {
            return;
        }
        pathData = ShapeUtils.minimizePathDataString(pathData, this.decimalDigits);
        Element pathElement = this.doc.createElement(SVG_PATH_ELEMENT);
        pathElement.setAttribute(SVG_D, pathData);
        VGGradient svgGradient = style.getGradient();
        String fillRule = this.convertFillRule(style.getFillRule());
        pathElement.setAttribute(SVG_FILLRULE, fillRule);
        if (svgGradient != null) {
            LinearGradient.LinearGradientStop[] gradientStops;
            Element gradientElement = this.doc.createElement(SVG_GRADIENT_ELEMENT);
            this.defs.appendChild(gradientElement);
            pathElement.setAttribute(SVG_FILL, "url(#" + name + ")");
            gradientElement.setAttribute(SVG_GRADIENT_ID, name);
            gradientElement.setAttribute(SVG_GRADIENT_GRADIENTUNITS, SVG_GRADIENT_GRADIENTUNITS_USERSPACEONUSE);
            float x1 = svgGradient.getXStart();
            float y1 = svgGradient.getYStart();
            float x2 = svgGradient.getXEnd();
            float y2 = svgGradient.getYEnd();
            Point2D.Float origin = new Point2D.Float(x1, y1);
            Point2D.Float end = new Point2D.Float(x2, y2);
            Point2D.Float originTransformed = new Point2D.Float(0.0f, 0.0f);
            Point2D.Float endTransformed = new Point2D.Float(0.0f, 0.0f);
            at.transform(origin, originTransformed);
            at.transform(end, endTransformed);
            x1 = (float)((Point2D)originTransformed).getX();
            y1 = (float)((Point2D)originTransformed).getY();
            x2 = (float)((Point2D)endTransformed).getX();
            y2 = (float)((Point2D)endTransformed).getY();
            float length = (float)Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
            if (0.0f == length) {
                Shape s = ShapeUtils.getPathShape(pathData);
                x1 = (float)s.getBounds2D().getMinX();
                y1 = (float)s.getBounds2D().getMinY();
                x2 = (float)s.getBounds2D().getMaxX();
                y2 = (float)s.getBounds2D().getMaxY();
            }
            gradientElement.setAttribute(SVG_GRADIENT_STARTX, Float.toString(x1));
            gradientElement.setAttribute(SVG_GRADIENT_STARTY, Float.toString(y1));
            gradientElement.setAttribute(SVG_GRADIENT_ENDX, Float.toString(x2));
            gradientElement.setAttribute(SVG_GRADIENT_ENDY, Float.toString(y2));
            LinearGradient.LinearGradientStop[] linearGradientStopArray = gradientStops = svgGradient.getStops();
            int n = gradientStops.length;
            int n2 = 0;
            while (n2 < n) {
                LinearGradient.LinearGradientStop gradientStop = linearGradientStopArray[n2];
                Element itemElement = this.doc.createElement(SVG_STOP_ELEMENT);
                gradientElement.appendChild(itemElement);
                itemElement.setAttribute(SVG_GRADIENT_COLOR, this.getHexa(this.convertColor(gradientStop.getColor())));
                itemElement.setAttribute(SVG_GRADIENT_OPACITY, Float.toString(gradientStop.getOpacity()));
                itemElement.setAttribute(SVG_GRADIENT_OFFSET, Float.toString(gradientStop.getPosition()));
                ++n2;
            }
        } else {
            int fill = this.convertColor(style.getFill().getColor());
            pathElement.setAttribute(SVG_FILL, this.getHexa(fill));
            float opacity = style.getOpacity();
            if (style.getNoFill()) {
                opacity = 0.0f;
            }
            pathElement.setAttribute(SVG_FILL_OPACITY, Float.toString(opacity));
        }
        svgParent.appendChild(pathElement);
    }

    private Element printAnimations(VGGroupAnimate vggroup, Element svgGroup) {
        VGAnimation[] animations = vggroup.getAnimations().toArray();
        Element parentElement = svgGroup;
        if (animations.length != 0) {
            int animationId = 0;
            while (animationId < animations.length) {
                Element animateTransform = this.doc.createElement(SVG_ANIMATETRANSFORM_ELEMENT);
                parentElement.appendChild(animateTransform);
                VGAnimation animation = animations[animationId];
                animateTransform.setAttribute("attributeName", SVG_TRANSFORM);
                animateTransform.setAttribute("additive", "sum");
                animateTransform.setAttribute("dur", String.valueOf(animation.getDuration()) + "ms");
                animateTransform.setAttribute("begin", String.valueOf(animation.getStartOffset()) + "ms");
                String from = "";
                String to = "";
                if (VGUtils.isAnimationTranslate(animation)) {
                    VGTranslateAnimation translateAnimation = (VGTranslateAnimation)animation;
                    animateTransform.setAttribute("type", "translate");
                    from = String.valueOf(translateAnimation.getStartX()) + " " + translateAnimation.getStartY();
                    to = String.valueOf(translateAnimation.getStartX() + translateAnimation.getTranslationX()) + " " + (translateAnimation.getStartY() + translateAnimation.getTranslationY());
                }
                if (VGUtils.isAnimationScale(animation)) {
                    VGScaleAnimation scaleAnimation = (VGScaleAnimation)animation;
                    from = String.valueOf(scaleAnimation.getScaleXFrom()) + " " + scaleAnimation.getScaleYFrom();
                    to = String.valueOf(scaleAnimation.getScaleXTo()) + " " + scaleAnimation.getScaleYTo();
                    animateTransform.setAttribute("type", "scale");
                    if (scaleAnimation.getPivotX() != 0.0f || scaleAnimation.getPivotY() != 0.0f) {
                        parentElement.setAttribute(SVG_TRANSFORM_ORIGIN, String.valueOf(scaleAnimation.getPivotX()) + " " + scaleAnimation.getPivotY());
                    }
                }
                if (VGUtils.isAnimationRotate(animation)) {
                    VGRotateAnimation rotateAnimation = (VGRotateAnimation)animation;
                    from = String.valueOf(rotateAnimation.getStartAngle()) + " " + rotateAnimation.getStartRotationCenterX() + " " + rotateAnimation.getStartRotationCenterY();
                    to = String.valueOf(rotateAnimation.getStartAngle() + rotateAnimation.getRotationAngle()) + " " + (rotateAnimation.getStartRotationCenterX() + rotateAnimation.getRotationTranslationCenterX()) + " " + (rotateAnimation.getStartRotationCenterY() + rotateAnimation.getRotationTranslationCenterY());
                    animateTransform.setAttribute("type", "rotate");
                }
                animateTransform.setAttribute("from", from);
                animateTransform.setAttribute("to", to);
                if (-1 == animation.getKeepDuration()) {
                    animateTransform.setAttribute(SVG_FILL, "freeze");
                } else if (animation.getKeepDuration() != 0) {
                    Element keepDuration = this.doc.createElement(SVG_ANIMATETRANSFORM_ELEMENT);
                    svgGroup.appendChild(keepDuration);
                    keepDuration.setAttribute("attributeName", SVG_TRANSFORM);
                    keepDuration.setAttribute("additive", "sum");
                    keepDuration.setAttribute("dur", String.valueOf(animation.getKeepDuration()) + "ms");
                    keepDuration.setAttribute("begin", String.valueOf(animation.getStartOffset() + animation.getDuration()) + "ms");
                    keepDuration.setAttribute("type", animateTransform.getAttribute("type"));
                    keepDuration.setAttribute("from", to);
                    keepDuration.setAttribute("to", to);
                }
                if (animationId != animations.length - 1 && animations[animationId].getClass() != animations[animationId + 1].getClass()) {
                    Element newgroupElement = this.doc.createElement(SVG_GROUP_ELEMENT);
                    parentElement.appendChild(newgroupElement);
                    parentElement = newgroupElement;
                }
                ++animationId;
            }
        }
        return parentElement;
    }
}

