/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator;

import com.microej.converter.vectorimage.InvalidOutputException;
import com.microej.converter.vectorimage.Logger;
import com.microej.converter.vectorimage.ShapeUtils;
import com.microej.converter.vectorimage.generator.AbstractGenerator;
import com.microej.converter.vectorimage.vg.VGColor;
import com.microej.converter.vectorimage.vg.VGGradient;
import com.microej.converter.vectorimage.vg.VGGroup;
import com.microej.converter.vectorimage.vg.VGGroupTransform;
import com.microej.converter.vectorimage.vg.VGPath;
import com.microej.converter.vectorimage.vg.VGStyle;
import ej.microvg.image.LinearGradient;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AvdGenerator
extends AbstractGenerator {
    private static final String ANDROID_XML_FORMAT = "xmlns:android";
    private static final String ANDROID_XML_FORMAT_URL = "http://schemas.android.com/apk/res/android";
    private static final String ANDROID_XML_AAPT = "xmlns:aapt";
    private static final String ANDROID_XML_AAPT_URL = "http://schemas.android.com/aapt";
    private static final String ANDROID_VECTOR_ELEMENT = "vector";
    private static final String ANDROID_GROUP_ELEMENT = "group";
    private static final String ANDROID_PATH_ELEMENT = "path";
    private static final String ANDROID_AAPT_ATTR_ELEMENT = "aapt:attr";
    private static final String ANDROID_GRADIENT_ELEMENT = "gradient";
    private static final String ANDROID_WIDTH = "android:width";
    private static final String ANDROID_HEIGHT = "android:height";
    private static final String ANDROID_VIEWPORTWIDTH = "android:viewportWidth";
    private static final String ANDROID_VIEWPORTHEIGHT = "android:viewportHeight";
    private static final String ANDROID_NAME = "android:name";
    private static final String ANDROID_PATHDATA = "android:pathData";
    private static final String ANDROID_FILLCOLOR = "android:fillColor";
    private static final String ANDROID_AAPT_NAME = "name";
    private static final String ANDROID_FILLTYPE = "android:fillType";
    private static final String ANDROID_FILLTYPE_NONZERO = "nonZero";
    private static final String ANDROID_FILLTYPE_EVENODD = "evenOdd";
    private static final String ANDROID_GRADIENT_STARTX = "android:startX";
    private static final String ANDROID_GRADIENT_STARTY = "android:startY";
    private static final String ANDROID_GRADIENT_ENDX = "android:endX";
    private static final String ANDROID_GRADIENT_ENDY = "android:endY";
    private static final String ANDROID_GRADIENT_TYPE = "android:type";
    private static final String ANDROID_GRADIENT_TYPE_LINEAR = "android:linear";
    private static final String ANDROID_GRADIENT_COLOR = "android:color";
    private static final String ANDROID_GRADIENT_OFFSET = "android:offset";
    private final int decimalDigits;
    private final String imageName;
    private final File outputFile;
    private Document doc;
    private Element vectorElement;
    private Element currentParent;
    private AffineTransform currentTransform;

    public AvdGenerator(String outputFolder, String outputName, String imageName, int decimalDigits) {
        this.imageName = imageName;
        this.decimalDigits = decimalDigits;
        this.outputFile = AvdGenerator.getOutputFile(outputFolder, outputName);
        File parentFolder = this.outputFile.getParentFile();
        if (!parentFolder.exists() && !parentFolder.mkdirs()) {
            throw new InvalidOutputException("Invalid output parameters for android vector drawable. " + this.outputFile.getAbsolutePath() + " cannot be written.");
        }
    }

    private static File getOutputFile(String outputFolder, String outputName) {
        if (outputFolder == null) {
            outputFolder = System.getProperty("user.dir");
        }
        String path = String.valueOf(outputFolder) + File.separatorChar + outputName;
        return new File(path);
    }

    @Override
    public void init(float width, float height, boolean hasOverlappingPaths, boolean hierarchical) throws Exception {
        super.init(width, height, hasOverlappingPaths, hierarchical);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
        this.vectorElement = this.doc.createElement(ANDROID_VECTOR_ELEMENT);
        this.vectorElement.setAttribute(ANDROID_XML_FORMAT, ANDROID_XML_FORMAT_URL);
        this.vectorElement.setAttribute(ANDROID_WIDTH, String.valueOf(Float.toString(width)) + "dp");
        this.vectorElement.setAttribute(ANDROID_HEIGHT, String.valueOf(Float.toString(height)) + "dp");
        this.vectorElement.setAttribute(ANDROID_VIEWPORTWIDTH, Float.toString(width));
        this.vectorElement.setAttribute(ANDROID_VIEWPORTHEIGHT, Float.toString(height));
        Comment comment = this.doc.createComment("microej:version=\"" + System.getProperty("vectorimage-converter.version") + "\" microej:imageName=\"" + this.imageName + "\"");
        this.vectorElement.appendChild(comment);
        this.currentParent = this.vectorElement;
        this.currentTransform = new AffineTransform();
    }

    private String convertFillRule(boolean fillRule) {
        if (fillRule) {
            return ANDROID_FILLTYPE_EVENODD;
        }
        return ANDROID_FILLTYPE_NONZERO;
    }

    private String getHexa(int fill) {
        return String.format("#%08X", fill);
    }

    @Override
    public void end() throws Exception {
        this.doc.appendChild(this.vectorElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = new DOMSource(this.doc);
        StreamResult result = new StreamResult(this.outputFile.getPath());
        transformer.transform(source, result);
        Logger.logString("Android vectordrawable file generated: " + this.outputFile.getAbsolutePath());
    }

    @Override
    public void print(VGGroup vgGroup) throws Exception {
        Element previousParent = this.currentParent;
        AffineTransform previousTransform = this.currentTransform;
        Element groupElement = null;
        this.currentTransform = new AffineTransform(this.currentTransform);
        if (vgGroup instanceof VGGroupTransform) {
            this.currentTransform.concatenate(((VGGroupTransform)vgGroup).getTransformation());
        }
        if (this.isHierarchical()) {
            groupElement = this.doc.createElement(ANDROID_GROUP_ELEMENT);
            if (vgGroup.getName() != null && !vgGroup.getName().equals("")) {
                groupElement.setAttribute(ANDROID_NAME, vgGroup.getName());
            }
            if (!vgGroup.canRemove()) {
                this.currentParent.appendChild(groupElement);
            } else {
                groupElement = this.currentParent;
            }
        } else {
            groupElement = this.currentParent;
        }
        this.currentParent = groupElement;
        super.print(vgGroup);
        this.currentParent = previousParent;
        this.currentTransform = previousTransform;
    }

    @Override
    public void print(VGPath vgPath) throws Exception {
        String pathData = vgPath.getPathData();
        if (!this.isHierarchical()) {
            Shape transformedShape = this.currentTransform.createTransformedShape(ShapeUtils.getPathShape(pathData));
            pathData = ShapeUtils.getPathString(transformedShape);
        }
        this.printPath(this.currentParent, vgPath.getName(), pathData, vgPath.getStyle(), this.currentTransform);
    }

    private void printPath(Element svgParent, String name, String pathData, VGStyle style, AffineTransform at) {
        if (pathData.equals("")) {
            return;
        }
        pathData = ShapeUtils.minimizePathDataString(pathData, this.decimalDigits);
        Element pathElement = this.doc.createElement(ANDROID_PATH_ELEMENT);
        pathElement.setAttribute(ANDROID_PATHDATA, pathData);
        VGGradient svgGradient = style.getGradient();
        float opacity = style.getOpacity();
        if (style.getNoFill()) {
            opacity = 0.0f;
        }
        String fillRule = this.convertFillRule(style.getFillRule());
        pathElement.setAttribute(ANDROID_FILLTYPE, fillRule);
        if (svgGradient != null) {
            LinearGradient.LinearGradientStop[] gradientStops;
            this.vectorElement.setAttribute(ANDROID_XML_AAPT, ANDROID_XML_AAPT_URL);
            Element fillColorElement = this.doc.createElement(ANDROID_AAPT_ATTR_ELEMENT);
            pathElement.appendChild(fillColorElement);
            fillColorElement.setAttribute(ANDROID_AAPT_NAME, ANDROID_FILLCOLOR);
            Element gradientElement = this.doc.createElement(ANDROID_GRADIENT_ELEMENT);
            fillColorElement.appendChild(gradientElement);
            float x1 = svgGradient.getXStart();
            float y1 = svgGradient.getYStart();
            float x2 = svgGradient.getXEnd();
            float y2 = svgGradient.getYEnd();
            Point2D.Float origin = new Point2D.Float(x1, y1);
            Point2D.Float end = new Point2D.Float(x2, y2);
            Point2D.Float originTransformed = new Point2D.Float(0.0f, 0.0f);
            Point2D.Float endTransformed = new Point2D.Float(0.0f, 0.0f);
            at.transform(origin, originTransformed);
            at.transform(end, endTransformed);
            x1 = (float)((Point2D)originTransformed).getX();
            y1 = (float)((Point2D)originTransformed).getY();
            x2 = (float)((Point2D)endTransformed).getX();
            y2 = (float)((Point2D)endTransformed).getY();
            float length = (float)Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
            if (0.0f == length) {
                Shape s = ShapeUtils.getPathShape(pathData);
                x1 = (float)s.getBounds2D().getMinX();
                y1 = (float)s.getBounds2D().getMinY();
                x2 = (float)s.getBounds2D().getMaxX();
                y2 = (float)s.getBounds2D().getMaxY();
            }
            gradientElement.setAttribute(ANDROID_GRADIENT_STARTX, Float.toString(x1));
            gradientElement.setAttribute(ANDROID_GRADIENT_STARTY, Float.toString(y1));
            gradientElement.setAttribute(ANDROID_GRADIENT_ENDX, Float.toString(x2));
            gradientElement.setAttribute(ANDROID_GRADIENT_ENDY, Float.toString(y2));
            gradientElement.setAttribute(ANDROID_GRADIENT_TYPE, ANDROID_GRADIENT_TYPE_LINEAR);
            LinearGradient.LinearGradientStop[] linearGradientStopArray = gradientStops = svgGradient.getStops();
            int n = gradientStops.length;
            int n2 = 0;
            while (n2 < n) {
                LinearGradient.LinearGradientStop gradientStop = linearGradientStopArray[n2];
                Element itemElement = this.doc.createElement("item");
                gradientElement.appendChild(itemElement);
                itemElement.setAttribute(ANDROID_GRADIENT_COLOR, this.getHexa(AvdGenerator.convertColor(gradientStop.getColor(), gradientStop.getOpacity())));
                itemElement.setAttribute(ANDROID_GRADIENT_OFFSET, Float.toString(gradientStop.getPosition()));
                ++n2;
            }
        } else {
            int fill = AvdGenerator.convertColor(style.getFill(), opacity);
            pathElement.setAttribute(ANDROID_FILLCOLOR, this.getHexa(fill));
        }
        svgParent.appendChild(pathElement);
    }

    public static int convertColor(VGColor color, float opacity) {
        return AvdGenerator.convertColor(color.getColor(), opacity);
    }

    public static int convertColor(Color color, float opacity) {
        int newColor = 0;
        newColor |= color.getRed() << 16;
        newColor |= color.getGreen() << 8;
        newColor |= color.getBlue();
        return newColor |= (int)(opacity * 255.0f) << 24;
    }
}

