/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator;

import com.microej.converter.vectorimage.vg.VGAlphaAnimation;
import com.microej.converter.vectorimage.vg.VGAnimation;
import com.microej.converter.vectorimage.vg.VGAnimations;
import com.microej.converter.vectorimage.vg.VGColorAnimation;
import com.microej.converter.vectorimage.vg.VGElement;
import com.microej.converter.vectorimage.vg.VGGroup;
import com.microej.converter.vectorimage.vg.VGGroupAnimate;
import com.microej.converter.vectorimage.vg.VGGroupMaster;
import com.microej.converter.vectorimage.vg.VGGroupTransform;
import com.microej.converter.vectorimage.vg.VGPath;
import com.microej.converter.vectorimage.vg.VGPathColor;
import com.microej.converter.vectorimage.vg.VGPathDataAnimation;
import com.microej.converter.vectorimage.vg.VGPathGradient;
import com.microej.converter.vectorimage.vg.VGRotateAnimation;
import com.microej.converter.vectorimage.vg.VGScaleAnimation;
import com.microej.converter.vectorimage.vg.VGTranslateAnimation;
import com.microej.converter.vectorimage.vg.VGTranslateXYAnimation;

public abstract class AbstractGenerator {
    protected boolean hierarchical;
    protected boolean hasOverlappingPaths;

    public void init(float width, float height, boolean hasOverlappingPaths, boolean hierarchical) throws Exception {
        this.hierarchical = hierarchical;
        this.hasOverlappingPaths = hasOverlappingPaths;
    }

    public abstract void end() throws Exception;

    public boolean isHierarchical() {
        return this.hierarchical;
    }

    public void print(VGGroupMaster vgMaster) throws Exception {
        if (vgMaster.hasTransformations()) {
            this.print((VGGroupTransform)vgMaster);
        } else {
            this.print((VGGroup)vgMaster);
        }
    }

    public void print(VGGroupTransform vgGroup) throws Exception {
        this.print((VGGroup)vgGroup);
    }

    public void print(VGGroupAnimate vgGroup) throws Exception {
        vgGroup.getAnimations().print(this);
        this.print((VGGroup)vgGroup);
    }

    public void print(VGAnimations animations) {
        VGAnimation[] vGAnimationArray = animations.toArray();
        int n = vGAnimationArray.length;
        int n2 = 0;
        while (n2 < n) {
            VGAnimation animation = vGAnimationArray[n2];
            animation.print(this);
            ++n2;
        }
    }

    public void print(VGColorAnimation animation) {
        this.print((VGAnimation)animation);
    }

    public void print(VGAlphaAnimation animation) {
        this.print((VGAnimation)animation);
    }

    public void print(VGPathDataAnimation animation) {
        this.print((VGAnimation)animation);
    }

    public void print(VGRotateAnimation animation) {
        this.print((VGAnimation)animation);
    }

    public void print(VGScaleAnimation animation) {
        this.print((VGAnimation)animation);
    }

    public void print(VGTranslateAnimation animation) {
        this.print((VGAnimation)animation);
    }

    public void print(VGTranslateXYAnimation animation) {
        this.print((VGAnimation)animation);
    }

    public void print(VGAnimation animation) {
    }

    public abstract void print(VGPath var1) throws Exception;

    public void print(VGPathColor p) throws Exception {
        if (p.hasAnimations()) {
            this.printVGPathColorAnimated(p);
        } else {
            this.printVGPathColorNotAnimated(p);
        }
    }

    public void printVGPathColorAnimated(VGPathColor vgPathColor) throws Exception {
        vgPathColor.getColorAnimations().print(this);
        vgPathColor.getAlphaAnimations().print(this);
        vgPathColor.getPathDataAnimations().print(this);
        this.print((VGPath)vgPathColor);
    }

    public void printVGPathColorNotAnimated(VGPathColor vgPathColor) throws Exception {
        this.print((VGPath)vgPathColor);
    }

    public void print(VGPathGradient p) throws Exception {
        if (p.hasAnimations()) {
            this.printVGPathGradientAnimated(p);
        } else {
            this.printVGPathGradientNotAnimated(p);
        }
    }

    public void printVGPathGradientAnimated(VGPathGradient vgPath) throws Exception {
        vgPath.getAlphaAnimations().print(this);
        vgPath.getPathDataAnimations().print(this);
        this.print((VGPath)vgPath);
    }

    public void printVGPathGradientNotAnimated(VGPathGradient vgPath) throws Exception {
        this.print((VGPath)vgPath);
    }

    public void print(VGGroup vgGroup) throws Exception {
        for (VGElement child : vgGroup.getChildren()) {
            child.print(this);
        }
    }
}

