/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage;

import com.microej.converter.vectorimage.Logger;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathParser;

public class ShapeUtils {
    public static final String MOVE_CMD = "M";
    public static final String LINE_CMD = "L";
    public static final String CURVE_CMD = "C";
    public static final String QUAD_CMD = "Q";
    public static final String CLOSE_CMD = "Z";

    public static String getPathString(Shape s) {
        return ShapeUtils.getPathString(s, null);
    }

    public static String getPathString(Shape s, AffineTransform at) {
        PathIterator pi = s.getPathIterator(at);
        return ShapeUtils.getPathString(s, at, pi, false);
    }

    public static String getFlattenedPathString(Shape s, AffineTransform at, double flatness) {
        FlatteningPathIterator pi = new FlatteningPathIterator(s.getPathIterator(null), flatness);
        return ShapeUtils.getPathString(s, at, pi, false);
    }

    public static String getPathCmdString(Shape s) {
        PathIterator pi = s.getPathIterator(null);
        return ShapeUtils.getPathString(s, null, pi, true);
    }

    private static String getPathString(Shape s, AffineTransform at, PathIterator pi, boolean cmdOnly) {
        StringBuilder builder = new StringBuilder("");
        double[] coords = new double[6];
        while (!pi.isDone()) {
            int cmd = pi.currentSegment(coords);
            int nbArgs = 0;
            switch (cmd) {
                case 4: {
                    builder.append(String.format(" %s", CLOSE_CMD));
                    break;
                }
                case 3: {
                    builder.append(String.format(" %s", CURVE_CMD));
                    nbArgs = 6;
                    break;
                }
                case 2: {
                    builder.append(String.format(" %s", QUAD_CMD));
                    nbArgs = 4;
                    break;
                }
                case 1: {
                    builder.append(String.format(" %s", LINE_CMD));
                    nbArgs = 2;
                    break;
                }
                case 0: {
                    builder.append(String.format(" %s", MOVE_CMD));
                    nbArgs = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected segment type (" + cmd + ")");
                }
            }
            if (!cmdOnly) {
                int i = 0;
                while (i < nbArgs) {
                    builder.append(String.format(" %f", coords[i]));
                    ++i;
                }
            }
            pi.next();
        }
        return builder.toString();
    }

    public static String minimizePathDataString(String pathData, int nbDigits) {
        String regExp = "([0-9]+.";
        int i = 0;
        while (i < nbDigits) {
            regExp = String.valueOf(regExp) + "[0-9]";
            ++i;
        }
        regExp = String.valueOf(regExp) + ")[0-9]+";
        String newPathData = pathData.replaceAll(regExp, "$1");
        regExp = "([0-9]+).";
        int i2 = 0;
        while (i2 < nbDigits) {
            regExp = String.valueOf(regExp) + "0";
            ++i2;
        }
        newPathData = newPathData.replaceAll(regExp, "$1");
        newPathData = newPathData.replaceAll("([0-9]) ([0-9])", "$1,$2");
        newPathData = newPathData.replaceAll("([0-9]) ([0-9])", "$1,$2");
        newPathData = newPathData.replace(" ", "");
        newPathData = newPathData.replace(CLOSE_CMD, "Z ");
        return newPathData;
    }

    public static Shape clipShape(Shape shape, Shape clip) {
        if (shape == null) {
            return clip;
        }
        if (clip == null) {
            return shape;
        }
        Area area = new Area(shape);
        if (area.isEmpty()) {
            return shape;
        }
        Area clipArea = new Area(clip);
        area.intersect(clipArea);
        Logger.logDebugString("[Warning] Clipping shape");
        Logger.logDebugString("    Shape:" + ShapeUtils.getPathString(shape));
        Logger.logDebugString("    Clip:" + ShapeUtils.getPathString(clip));
        return area;
    }

    public static boolean overlapping(Shape s0, Shape s1) {
        if (s0 == null || s1 == null) {
            return false;
        }
        Area area0 = new Area(s0);
        Area area1 = new Area(s1);
        area0.intersect(area1);
        return !area0.isEmpty();
    }

    public static Shape getPathShape(String str) {
        PathParser pp = new PathParser();
        AWTPathProducer ph = new AWTPathProducer();
        pp.setPathHandler(ph);
        try {
            pp.parse(str);
        }
        catch (ParseException parseException) {
            str = str.replaceAll("c\\s+", "");
            try {
                pp.parse(str);
            }
            catch (ParseException e1) {
                Logger.logErrString("Can not parse path string(" + e1.getMessage() + "):" + str);
            }
        }
        return ph.getShape();
    }

    public static Shape union(Shape s0, Shape s1) {
        if (s0 == null && s1 == null) {
            return null;
        }
        if (s0 == null) {
            return s1;
        }
        if (s1 == null) {
            return s0;
        }
        Area area0 = new Area(s0);
        Area area1 = new Area(s1);
        area0.add(area1);
        return area0;
    }
}

