/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage;

import com.microej.arguments.ArgumentParser;
import com.microej.arguments.GenericArgument;
import com.microej.arguments.ToggleArgument;
import com.microej.arguments.UnexpectedArgumentException;
import com.microej.converter.vectorimage.FileParser;
import com.microej.converter.vectorimage.GPU;
import com.microej.converter.vectorimage.InvalidOutputException;
import com.microej.converter.vectorimage.Logger;
import com.microej.converter.vectorimage.generator.AbstractGenerator;
import com.microej.converter.vectorimage.generator.AvdGenerator;
import com.microej.converter.vectorimage.generator.SvgGenerator;
import com.microej.converter.vectorimage.generator.text.InfoGenerator;
import com.microej.converter.vectorimage.svg.SVGParser;
import com.microej.converter.vectorimage.vd.VectorDrawableParser;
import ej.microvg.image.ImageGenerator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Main {
    public static final String VERSION_KEY = "vectorimage-converter.version";
    private static final int DEFAULT_DECIMAL_DIGITS = 2;

    public static void main(String[] args) throws Exception {
        Main.run0(args);
    }

    public static boolean run(String[] args) {
        try {
            return Main.run0(args);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean run0(String[] args) throws Exception {
        String gpuValue;
        ImageGenerator.Format format;
        Locale.setDefault(Locale.US);
        ArgumentParser argParser = new ArgumentParser("java -jar vectorimage-converter.jar", " --input \"<path-to-vectorial-image-file>\" [--folder \"<path-to-output-directory>\"] {--raw myRaw.bin | --immutablesVectorImage myimmutable.xml | --class my.package.Class | --avd myAvd.xml | --svg mySVG.svg} [--gpu GPU] [--format FORMAT] [--pathinfo] [--list] [--verbose LEVEL] [--hierarchical] [--decimalDigits NBDIGITS]");
        GenericArgument<String> inputFileArg = new GenericArgument<String>(argParser, String.class, "input file (SVG or VectorDrawable)", null, "input");
        GenericArgument<String> outputAvdFileArg = new GenericArgument<String>(argParser, String.class, "output android vectordrawable file name (myAvd.xml)", "a", "avd");
        GenericArgument<String> outputSvgFileArg = new GenericArgument<String>(argParser, String.class, "output SVG file name (mySVG.svg)", "s", "svg");
        GenericArgument<String> outputRawArg = new GenericArgument<String>(argParser, String.class, "output RAW file", "r", "raw");
        GenericArgument<String> gpuArg = new GenericArgument<String>(argParser, String.class, "Implementation of com.microej.converter.vectorimage.generator.raw.Generator", "g", "gpu");
        GenericArgument<String> folderArg = new GenericArgument<String>(argParser, String.class, "output folder", "f", "folder");
        GenericArgument<String> formatArg = new GenericArgument<String>(argParser, String.class, "output format: one of \"S8\", \"S16\", \"S32\", \"FP32\" (default)", null, "format");
        GenericArgument<String> identifierArg = new GenericArgument<String>(argParser, String.class, "output identifier: id in the output file (if required), use file name by default", null, "identifier");
        ToggleArgument infoArg = new ToggleArgument(argParser, "print path information", null, "pathinfo");
        ToggleArgument hierArg = new ToggleArgument(argParser, "keep hierarchy in output file when available", null, "hierarchical");
        GenericArgument<Integer> verboseArg = new GenericArgument<Integer>(argParser, Integer.class, "verbosity level, one of \n\t0 (Errors)\n\t1 (Errors+Warnings)\n\t2 (Errors+Warnings+Logs) (default) \n\t3 (Errors+Warnings+Logs+Debug)", null, "verbose");
        GenericArgument<Integer> decimalDigitsArg = new GenericArgument<Integer>(argParser, Integer.class, "number of decimal digit in avd/svg output file paths)", null, "decimalDigits");
        new ToggleArgument(argParser, "generate .list file", null, "list");
        ToggleArgument helpArg = new ToggleArgument(argParser, "this help", null, "help");
        boolean error = false;
        try {
            error = !argParser.parse(args);
        }
        catch (UnexpectedArgumentException e) {
            Logger.logWarnString("An unexpected argument has been found: " + e.getArgument());
            error = true;
        }
        catch (Exception exception) {
            Logger.logErrString("Unexpected exception when parsing command line: ");
            error = true;
        }
        if (verboseArg.getValue() != null) {
            Logger.setVerbosity(verboseArg.getValue());
        } else {
            Logger.setVerbosity(2);
        }
        if (helpArg.isSet() || error) {
            argParser.printSynopsis();
            return false;
        }
        int decimalDigits = 2;
        if (decimalDigitsArg.getValue() != null) {
            decimalDigits = decimalDigitsArg.getValue();
        }
        if (inputFileArg.getValue() == null) {
            Logger.logWarnString("Please add input SVG or AVD(--" + inputFileArg.getLongName() + ").");
            argParser.printSynopsis();
            return false;
        }
        String inputFile = "";
        if (inputFileArg.getValue() != null) {
            inputFile = inputFileArg.getValue();
        }
        String imageName = new File(inputFile).getName();
        String formatValue = formatArg.getValue();
        if (formatValue != null) {
            format = Main.parseFormat(formatValue);
            if (format == null) {
                Logger.logErrString("Wrong format: " + formatValue);
                argParser.printSynopsis();
                return false;
            }
        } else {
            format = ImageGenerator.Format.VG_FP32;
        }
        if ((gpuValue = gpuArg.getValue()) == null) {
            gpuValue = "vglite";
        }
        ArrayList<AbstractGenerator> printers = new ArrayList<AbstractGenerator>();
        String identifierValue = identifierArg.getValue();
        if (identifierValue == null) {
            identifierValue = imageName;
        }
        String[] printerArgs = new String[]{outputAvdFileArg.getValue(), outputSvgFileArg.getValue(), outputRawArg.getValue()};
        int i = 0;
        while (i < printerArgs.length) {
            String outputFilePath = printerArgs[i];
            if (outputFilePath != null) {
                try {
                    switch (i) {
                        case 0: {
                            printers.add(new AvdGenerator(folderArg.getValue(), outputFilePath, imageName, decimalDigits));
                            break;
                        }
                        case 1: {
                            printers.add(new SvgGenerator(folderArg.getValue(), outputFilePath, imageName, decimalDigits));
                            break;
                        }
                        case 2: {
                            printers.add(GPU.getRawPrinter(folderArg.getValue(), outputFilePath, gpuValue, format));
                            break;
                        }
                    }
                }
                catch (InvalidOutputException e) {
                    Logger.logWarnString(e.getMessage());
                    return false;
                }
            }
            ++i;
        }
        if (infoArg.isSet()) {
            printers.add(new InfoGenerator());
        }
        if (printers.isEmpty()) {
            Logger.logWarnString("Please choose an output (--" + outputAvdFileArg.getLongName() + "--" + outputSvgFileArg.getLongName() + ").");
            argParser.printSynopsis();
            return false;
        }
        Main.readProperties();
        Logger.logString("Start parsing of: " + inputFile);
        try {
            FileParser parser = Main.selectParser(inputFile);
            if (parser != null) {
                parser.getVGTopGroup().reduce();
                if (hierArg.isSet()) {
                    parser.getVGTopGroup().setChildrenNames("");
                    Logger.logDebugString(parser.getVGTopGroup().toString());
                }
                for (AbstractGenerator printer : printers) {
                    printer.init(parser.getSVGWidth(), parser.getSVGHeight(), parser.getVGTopGroup().hasOverlappingPaths(null), hierArg.isSet());
                    parser.getVGTopGroup().print(printer);
                    printer.end();
                }
                Logger.logString("BUILD SUCCESSFUL");
            }
        }
        catch (Exception e) {
            Logger.logErrString("Unexpected exception when parsing file(" + e.getMessage() + ")");
        }
        return true;
    }

    public static ImageGenerator.Format parseFormat(String formatValue) {
        switch (formatValue) {
            case "S8": {
                return ImageGenerator.Format.VG_S8;
            }
            case "S16": {
                return ImageGenerator.Format.VG_S16;
            }
            case "S32": {
                return ImageGenerator.Format.VG_S32;
            }
            case "FP32": {
                return ImageGenerator.Format.VG_FP32;
            }
        }
        return null;
    }

    private static void readProperties() {
        InputStream resource = Main.class.getResourceAsStream("/vectorimage-converter.properties");
        try {
            Properties properties = System.getProperties();
            properties.load(resource);
        }
        catch (IOException iOException) {}
    }

    private static FileParser selectParser(String inFilePath) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        File inputFile = new File(inFilePath);
        DocumentBuilderFactory dbFactory1 = DocumentBuilderFactory.newInstance();
        dbFactory1.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilderFactory dbFactory = dbFactory1;
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(inputFile);
        Element root = doc.getDocumentElement();
        String rootName = root.getTagName();
        if (rootName.equals("svg")) {
            return new SVGParser(inFilePath);
        }
        if (rootName.equals("vector") || rootName.equals("animated-vector")) {
            return new VectorDrawableParser(inFilePath);
        }
        Logger.logErrString("Can not find a suitable parser for " + rootName + " type file");
        return null;
    }
}

