/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage;

import com.microej.converter.vectorimage.InvalidOutputException;
import com.microej.converter.vectorimage.generator.AbstractGenerator;
import com.microej.converter.vectorimage.generator.raw.RawGenerator;
import ej.microvg.image.ImageGenerator;

public class GPU {
    public static AbstractGenerator getRawPrinter(String outputFolder, String outputName, String gpu, ImageGenerator.Format format) {
        return new RawGenerator(outputFolder, outputName, GPU.getRawPrinter(gpu, format));
    }

    private static ImageGenerator getRawPrinter(String gpu, ImageGenerator.Format format) {
        Class<ImageGenerator> clazz = ImageGenerator.class;
        String impl = String.valueOf(clazz.getPackage().getName()) + "." + GPU.capitalize(gpu) + clazz.getSimpleName();
        try {
            return (ImageGenerator)Class.forName(impl).getConstructor(ImageGenerator.Format.class).newInstance(new Object[]{format});
        }
        catch (Throwable throwable) {
            throw new InvalidOutputException("Invalid generator class: " + impl);
        }
    }

    private static String capitalize(String string) {
        char firstChar = string.charAt(0);
        string = string.toLowerCase().substring(1);
        return String.valueOf(Character.toUpperCase(firstChar)) + string;
    }
}

