/*
 * Decompiled with CFR 0.152.
 */
package com.microej.arguments;

import com.microej.arguments.ArgumentBase;
import com.microej.arguments.UnexpectedArgumentException;
import com.microej.converter.vectorimage.Logger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;

public class ArgumentParser {
    private int index;
    private String[] args;
    private final String programName;
    private final String commandLineSyntax;
    private final Map<String, ArgumentBase> shortCollection = new HashMap<String, ArgumentBase>();
    private final Map<String, ArgumentBase> longcollection = new HashMap<String, ArgumentBase>();
    private final Queue<ArgumentBase> positionalCollection = new LinkedList<ArgumentBase>();

    public ArgumentParser(String programName, String commandLineSyntax) {
        this.programName = programName;
        this.commandLineSyntax = commandLineSyntax;
    }

    public void printSynopsis() {
        ArgumentBase arg;
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: " + this.programName + " " + this.commandLineSyntax);
        int i = 1;
        while (i <= this.positionalCollection.size()) {
            sb.append("ARG" + i + " ");
            ++i;
        }
        sb.append("\n");
        sb.append("\n");
        if (!this.shortCollection.isEmpty()) {
            sb.append("short options:\n");
            List<String> sortedKeys = ArgumentParser.getOrderedList(this.shortCollection);
            for (String key : sortedKeys) {
                arg = this.shortCollection.get(key);
                sb.append("-" + arg.getShortName() + ": " + arg.getDescription() + "\n");
            }
            sb.append("\n");
        }
        if (!this.longcollection.isEmpty()) {
            sb.append("long options:\n");
            List<String> sortedKeys = ArgumentParser.getOrderedList(this.longcollection);
            for (String key : sortedKeys) {
                arg = this.longcollection.get(key);
                sb.append("--" + arg.getLongName() + ": " + arg.getDescription() + "\n");
            }
            sb.append("\n");
        }
        if (!this.positionalCollection.isEmpty()) {
            sb.append("positional arguments:\n");
            Iterator lIter = this.positionalCollection.iterator();
            int i2 = 1;
            while (lIter.hasNext()) {
                sb.append("ARG" + i2++ + ": " + ((ArgumentBase)lIter.next()).getDescription() + "\n");
            }
        }
        Logger.logWarnString(sb.toString());
    }

    public boolean parse(String[] args) throws Exception {
        this.index = 0;
        this.args = args;
        if (args.length == 0) {
            System.err.println("No argument found.");
            return false;
        }
        do {
            ArgumentBase arg;
            String argString;
            if ((argString = args[this.index]).startsWith("--")) {
                arg = this.longcollection.get(argString.substring(2));
                ++this.index;
            } else if (argString.startsWith("-")) {
                arg = this.shortCollection.get(argString.substring(1));
                ++this.index;
            } else {
                arg = this.positionalCollection.poll();
            }
            if (arg != null) {
                try {
                    arg.parse();
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.err.println("Malformed argument.");
                    return false;
                }
            } else {
                throw new UnexpectedArgumentException(args[this.index - 1]);
            }
        } while (this.index < args.length);
        return true;
    }

    public String consume() {
        return this.args[this.index++];
    }

    public void add(ArgumentBase argument) {
        if (argument.isPositional()) {
            this.positionalCollection.add(argument);
        } else {
            String shortName = argument.getShortName();
            String longName = argument.getLongName();
            if (shortName != null) {
                this.shortCollection.put(shortName, argument);
            }
            if (longName != null) {
                this.longcollection.put(longName, argument);
            }
        }
    }

    private static List<String> getOrderedList(Map<String, ArgumentBase> shortCollection) {
        return shortCollection.keySet().stream().sorted().collect(Collectors.toList());
    }

    public static <T> T getValueFromStr(String valueString, Class<T> returnType) throws Exception {
        if (returnType.equals(Integer.class)) {
            return (T)new Integer(valueString);
        }
        if (returnType.equals(Boolean.class)) {
            return (T)new Boolean(valueString);
        }
        if (returnType.equals(String.class)) {
            return (T)valueString;
        }
        throw new Exception("Unsupported type");
    }
}

