/*
 * Decompiled with CFR 0.152.
 */
package com.microej.arguments;

import com.microej.arguments.ArgumentParser;

public abstract class ArgumentBase {
    protected final ArgumentParser parser;
    private final String shortName;
    private final String longName;
    private final String description;

    public ArgumentBase(ArgumentParser parser, String description) {
        this(parser, description, null, null);
    }

    public ArgumentBase(ArgumentParser parser, String description, String shortName) {
        this(parser, description, shortName, null);
    }

    public ArgumentBase(ArgumentParser parser, String description, String shortName, String longName) {
        this.parser = parser;
        this.shortName = shortName;
        this.longName = longName;
        this.description = description;
        parser.add(this);
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public boolean isPositional() {
        return this.shortName == null && this.longName == null;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract void parse() throws Exception;
}

