/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.generator.font.format;

import com.is2t.generator.font.fontGeneratorA;
import fontGenerator.fontGeneratorB;
import fontGenerator.fontGeneratorM;
import fontGenerator.fontGeneratorpp;
import java.io.BufferedInputStream;

public abstract class Font {
    public static final int LATIN = 33;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int STYLE_PLAIN = 8;
    public static final int PROPORTIONAL = -1;
    public static final int SPACE = 32;
    public static final int TAB_WIDTH_IN_SPACES = 4;
    public static final int DEFAULT_BPP = 1;
    private final fontGeneratorB cr;
    public String descriptor;
    public fontGeneratorA[] characters;
    public int[] identifiers;
    public int height;
    public int width;
    public int baseline;
    public int space;
    public int tab;
    public int styles;
    public int filters;
    public int bpp;

    public Font() {
        this.cr = null;
    }

    protected Font(fontGeneratorB fontGeneratorB2) {
        this.cr = fontGeneratorB2;
    }

    protected Font(Font font) {
        this();
        this.descriptor = font.descriptor;
        this.identifiers = font.identifiers;
        this.characters = font.characters;
        this.height = font.height;
        this.width = font.width;
        this.baseline = font.baseline;
        this.space = font.space;
        this.tab = font.tab;
        this.styles = font.styles;
        this.filters = font.filters;
        this.bpp = font.bpp;
    }

    public abstract void decode(fontGeneratorM var1);

    public abstract int getHeapUsage();

    public BufferedInputStream getInputData() {
        return new BufferedInputStream(this.cr.a());
    }

    public int crop(fontGeneratorpp[] fontGeneratorppArray) {
        if (fontGeneratorppArray == null) {
            return -1;
        }
        fontGeneratorA[] fontGeneratorAArray = this.characters;
        int n = this.characters.length;
        int n2 = 0;
        fontGeneratorA[] fontGeneratorAArray2 = new fontGeneratorA[n];
        int n3 = -1;
        block0: while (++n3 < n) {
            int n4 = fontGeneratorAArray[n3].a;
            int n5 = fontGeneratorppArray.length;
            while (--n5 >= 0) {
                if (!fontGeneratorppArray[n5].a(n4)) continue;
                fontGeneratorAArray2[n2++] = fontGeneratorAArray[n3];
                continue block0;
            }
        }
        if (n2 == n) {
            return -1;
        }
        if (n2 == 0) {
            this.characters = new fontGeneratorA[0];
            return 11;
        }
        this.characters = new fontGeneratorA[n2];
        System.arraycopy(fontGeneratorAArray2, 0, this.characters, 0, n2);
        return -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("\n\t- descriptor = " + this.descriptor);
        stringBuilder.append("\n\t- nb characters = " + (this.characters == null ? 0 : this.characters.length));
        stringBuilder.append("\n\t- identifiers = ");
        if (this.identifiers == null) {
            stringBuilder.append("null");
        } else {
            int n = -1;
            while (++n < this.identifiers.length) {
                stringBuilder.append(this.identifiers[n]);
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append("\n\t- height = " + this.height);
        stringBuilder.append("\n\t- width = " + (this.width == -1 ? "proportional" : Integer.valueOf(this.width)));
        stringBuilder.append("\n\t- baseline = " + this.baseline);
        stringBuilder.append("\n\t- styles = 0x" + Integer.toHexString(this.styles));
        stringBuilder.append("\n\t- filters = 0x" + Integer.toHexString(this.filters));
        stringBuilder.append("\n\t- bpp = " + this.bpp);
        return stringBuilder.toString();
    }

    protected int getSizeInBytes(int n, int n2, int n3) {
        return (n * n3 + 7) / 8 * n2;
    }
}

