/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.util;

import com.microej.wear.kernel.proxies.Proxy;
import ej.annotation.Nullable;
import ej.kf.Feature;
import ej.kf.FeatureStateListener;
import ej.kf.Kernel;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class UntrackedProxyManager {
    private static final UntrackedProxyManager INSTANCE = new UntrackedProxyManager();
    private final Map<Proxy, Boolean> proxies = new WeakHashMap<Proxy, Boolean>();

    private UntrackedProxyManager() {
        Kernel.addFeatureStateListener((FeatureStateListener)new FeatureStateListener(){

            public void stateChanged(Feature feature, @Nullable Feature.State previousState) {
                if (feature.getState() == Feature.State.STOPPED) {
                    UntrackedProxyManager.this.removeFeatureReferences(feature);
                }
            }
        });
    }

    public static UntrackedProxyManager getInstance() {
        return INSTANCE;
    }

    public synchronized void add(Proxy proxy) {
        this.proxies.put(proxy, Boolean.TRUE);
    }

    private synchronized void removeFeatureReferences(Feature feature) {
        Iterator<Proxy> iterator = this.proxies.keySet().iterator();
        while (iterator.hasNext()) {
            Proxy proxy = iterator.next();
            if (!proxy.isFeatureReference(feature)) continue;
            proxy.removeReference();
            iterator.remove();
        }
    }
}

