/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.util;

import com.microej.wear.kernel.natives.FeatureFileNatives;
import ej.annotation.Nullable;
import ej.bon.IllegalStateException;
import java.io.IOException;
import java.io.InputStream;

public class FeatureFileInputStream
extends InputStream {
    private static boolean instanceOpen = false;
    private final byte[] singleByteBuffer = new byte[1];
    private boolean closed = false;

    private FeatureFileInputStream() {
    }

    @Nullable
    public static synchronized FeatureFileInputStream open() {
        if (instanceOpen) {
            throw new IllegalStateException("Existing instance still open");
        }
        if (FeatureFileNatives.open()) {
            instanceOpen = true;
            return new FeatureFileInputStream();
        }
        return null;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Closed");
        }
        byte[] buffer = this.singleByteBuffer;
        int read = FeatureFileNatives.read(buffer, 0, 1);
        return read > 0 ? buffer[0] & 0xFF : -1;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("Closed");
        }
        if (offset < 0 || length < 0 || offset + length > buffer.length) {
            throw new IllegalArgumentException();
        }
        return FeatureFileNatives.read(buffer, offset, length);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            FeatureFileNatives.close();
            FeatureFileInputStream.onInstanceClosed();
        }
    }

    private static synchronized void onInstanceClosed() {
        instanceOpen = false;
    }
}

