/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.util;

import com.microej.wear.KernelServiceProvider;
import com.microej.wear.components.Activity;
import com.microej.wear.components.Navigator;
import com.microej.wear.components.Renderable;
import com.microej.wear.components.Watchface;
import ej.annotation.Nullable;
import ej.microui.MicroUI;
import ej.microui.display.Display;
import ej.microui.display.Displayable;
import java.util.Objects;

public class DefaultNavigator
implements Navigator {
    @Nullable
    private Renderable currentRenderable;
    private int watchfaceIndex = -1;
    private boolean isOnWatchface = true;

    public boolean handleGesture(Navigator.Gesture gesture) {
        Objects.requireNonNull(gesture);
        switch (gesture) {
            case TOP_BUTTON_PRESS: {
                this.displayDefaultActivity();
                return true;
            }
            case MIDDLE_BUTTON_PRESS: {
                this.displayDefaultWatchface();
                return true;
            }
        }
        return false;
    }

    private void displayDefaultActivity() {
        if (!this.isOnWatchface) {
            this.displayDefaultWatchface();
            return;
        }
        Activity[] activities = KernelServiceProvider.getComponentService().getActivities();
        if (activities.length > 0) {
            this.isOnWatchface = false;
            this.showRenderable(activities[0].createRenderable());
        }
    }

    private void displayDefaultWatchface() {
        Watchface[] watchfaces = KernelServiceProvider.getComponentService().getWatchfaces();
        if (!this.isOnWatchface) {
            this.isOnWatchface = true;
            if (this.watchfaceIndex == -1) {
                this.watchfaceIndex = 0;
            }
            this.showRenderable(watchfaces[this.watchfaceIndex].createRenderable());
            return;
        }
        if (watchfaces.length > 1) {
            this.watchfaceIndex = (this.watchfaceIndex + 1) % 2;
            this.showRenderable(watchfaces[this.watchfaceIndex].createRenderable());
        }
    }

    private void showRenderable(final Renderable renderable) {
        Displayable displayable = Display.getDisplay().getDisplayable();
        if (displayable != null) {
            Display.getDisplay().requestHide(displayable);
            MicroUI.callSerially((Runnable)new Runnable(){

                @Override
                public void run() {
                    DefaultNavigator.this.proceedShowRenderable(renderable);
                }
            });
        } else {
            MicroUI.callSerially((Runnable)new Runnable(){

                @Override
                public void run() {
                }
            });
            this.proceedShowRenderable(renderable);
        }
    }

    private void proceedShowRenderable(Renderable renderable) {
        Renderable currentRenderable = this.currentRenderable;
        if (currentRenderable != null) {
            currentRenderable.onDetached();
        }
        renderable.onAttached();
        this.currentRenderable = renderable;
        renderable.showOnDisplay();
    }
}

