/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.ui;

import com.microej.wear.KernelServiceProvider;
import com.microej.wear.components.Renderable;
import com.microej.wear.components.TimeConfigurationListener;
import com.microej.wear.components.Watchface;
import com.microej.wear.kernel.util.TimeUtils;
import com.microej.wear.util.renderable.RenderableDisplayable;
import ej.annotation.Nullable;
import ej.bon.TimerTask;
import ej.microui.display.GraphicsContext;
import ej.microui.display.Painter;
import ej.microvg.VectorFont;
import ej.microvg.VectorGraphicsPainter;

public class DigitalWatchface
implements Watchface {
    private static final float FONT_SIZE = 96.0f;
    private static final long RENDER_PERIOD = 60000L;
    private static final long RENDER_DELAY = 100L;

    public void onPreviewAttached() {
    }

    public void onPreviewDetached() {
    }

    public void renderPreview(GraphicsContext g, int x, int y, int size) {
        g.setColor(0);
        Painter.fillCircle((GraphicsContext)g, (int)x, (int)y, (int)size);
        DigitalWatchface.renderTime(g, x, y, size, size);
    }

    public Renderable createRenderable() {
        return new DigitalRenderable();
    }

    private static void renderTime(GraphicsContext g, int x, int y, int width, int height) {
        long currentLocalTime = TimeUtils.getCurrentLocalTime();
        String text = DigitalWatchface.getTimeText(currentLocalTime);
        VectorFont font = KernelServiceProvider.getFontService().getRegularFont();
        float fontSize = 96.0f * (float)height / 390.0f;
        float textWidth = font.measureStringWidth(text, fontSize);
        float textHeight = font.getHeight(fontSize);
        float textX = (float)x + ((float)width - textWidth) / 2.0f;
        float textY = (float)y + ((float)height - textHeight) / 2.0f;
        g.setColor(0xFFFFFF);
        VectorGraphicsPainter.drawString((GraphicsContext)g, (String)text, (VectorFont)font, (float)fontSize, (float)textX, (float)textY);
    }

    private static String getTimeText(long time) {
        int hour = (int)(time / 3600000L % 24L);
        int minute = (int)(time / 60000L % 60L);
        StringBuilder stringBuilder = new StringBuilder();
        if (hour < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(hour);
        stringBuilder.append(':');
        if (minute < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(minute);
        return stringBuilder.toString();
    }

    private static class DigitalRenderable
    extends RenderableDisplayable
    implements TimeConfigurationListener {
        @Nullable
        private TimerTask timerTask;

        private DigitalRenderable() {
        }

        public void render(GraphicsContext gc) {
            int width = gc.getWidth();
            int height = gc.getHeight();
            gc.setColor(0);
            Painter.fillRectangle((GraphicsContext)gc, (int)0, (int)0, (int)width, (int)height);
            DigitalWatchface.renderTime(gc, 0, 0, width, height);
        }

        protected void onShown() {
            super.onShown();
            this.startRefreshTask();
            KernelServiceProvider.getTimeService().addConfigurationListener((TimeConfigurationListener)this);
        }

        protected void onHidden() {
            KernelServiceProvider.getTimeService().removeConfigurationListener((TimeConfigurationListener)this);
            this.stopRefreshTask();
        }

        public void onTimeConfigurationChanged(long currentTime, String zoneId, int zoneOffset) {
            this.stopRefreshTask();
            this.requestRender();
            this.startRefreshTask();
        }

        private void startRefreshTask() {
            TimerTask timerTask = new TimerTask(){

                public void run() {
                    DigitalRenderable.this.requestRender();
                }
            };
            long currentTime = KernelServiceProvider.getTimeService().getCurrentTime();
            long delay = 60000L - currentTime % 60000L + 100L;
            KernelServiceProvider.getTimer().scheduleAtFixedRate(timerTask, delay, 60000L);
            this.timerTask = timerTask;
        }

        private void stopRefreshTask() {
            TimerTask timerTask = this.timerTask;
            if (timerTask != null) {
                timerTask.cancel();
                this.timerTask = null;
            }
        }
    }
}

