/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.services;

import com.microej.wear.components.TimeConfigurationListener;
import com.microej.wear.kernel.natives.TimeNatives;
import com.microej.wear.kernel.proxies.Proxy;
import com.microej.wear.kernel.proxies.TimeConfigurationListenerProxy;
import com.microej.wear.kernel.util.ProxyArrayTools;
import com.microej.wear.services.TimeService;
import ej.annotation.Nullable;
import ej.basictool.ArrayTools;
import ej.kf.Feature;
import ej.kf.FeatureStateListener;
import ej.kf.Kernel;
import ej.sni.SNI;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;

public class KernelTimeService
implements TimeService {
    private static final int MAX_TIME_ZONE_ID_LENGTH = 50;
    @Nullable
    private static KernelTimeService instance;
    private ZoneId currentZoneId;
    private TimeConfigurationListenerProxy[] listeners = new TimeConfigurationListenerProxy[0];

    private KernelTimeService() {
        this.currentZoneId = KernelTimeService.readTimeZoneId();
        Kernel.addFeatureStateListener((FeatureStateListener)new FeatureStateListener(){

            public void stateChanged(Feature feature, @Nullable Feature.State previousState) {
                if (feature.getState() == Feature.State.STOPPED) {
                    KernelTimeService.this.removeFeatureReferences(feature);
                }
            }
        });
    }

    public static KernelTimeService getInstance() {
        KernelTimeService instance = KernelTimeService.instance;
        if (instance == null) {
            KernelTimeService.instance = instance = new KernelTimeService();
        }
        return instance;
    }

    public long getCurrentTime() {
        return TimeNatives.getCurrentTime();
    }

    public int getTimeZoneOffset() {
        return KernelTimeService.getTimeZoneOffset(TimeNatives.getCurrentTime(), this.currentZoneId);
    }

    public String getTimeZoneId() {
        return this.currentZoneId.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurationListener(TimeConfigurationListener listener) {
        Objects.requireNonNull(listener);
        Kernel.enter();
        TimeConfigurationListenerProxy proxy = new TimeConfigurationListenerProxy(listener);
        KernelTimeService kernelTimeService = this;
        synchronized (kernelTimeService) {
            this.listeners = (TimeConfigurationListenerProxy[])ArrayTools.add((Object[])this.listeners, (Object)proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigurationListener(TimeConfigurationListener listener) {
        Objects.requireNonNull(listener);
        Kernel.enter();
        KernelTimeService kernelTimeService = this;
        synchronized (kernelTimeService) {
            this.listeners = (TimeConfigurationListenerProxy[])ProxyArrayTools.removeSameReferences((Proxy[])this.listeners, (Object)listener);
        }
    }

    public void setTimeConfiguration(long currentTime, ZoneId zoneId, int zoneOffset) {
        String zoneIdString = zoneId.getId();
        TimeNatives.setCurrentTime(currentTime);
        TimeNatives.setTimeZoneId(SNI.toCString((String)zoneIdString));
        this.currentZoneId = zoneId;
        this.notifyListeners(currentTime, zoneIdString, zoneOffset);
    }

    private void notifyListeners(long time, String zoneId, int zoneOffset) {
        TimeConfigurationListenerProxy[] timeConfigurationListeners;
        TimeConfigurationListenerProxy[] timeConfigurationListenerProxyArray = timeConfigurationListeners = this.listeners;
        int n = timeConfigurationListeners.length;
        int n2 = 0;
        while (n2 < n) {
            TimeConfigurationListenerProxy listener = timeConfigurationListenerProxyArray[n2];
            listener.onTimeConfigurationChanged(time, zoneId, zoneOffset);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFeatureReferences(Feature feature) {
        KernelTimeService kernelTimeService = this;
        synchronized (kernelTimeService) {
            this.listeners = (TimeConfigurationListenerProxy[])ProxyArrayTools.removeFeatureReferences((Proxy[])this.listeners, (Feature)feature);
        }
    }

    private static ZoneId readTimeZoneId() {
        ZoneId zoneId;
        byte[] buffer = new byte[50];
        TimeNatives.getTimeZoneId(buffer);
        String id = SNI.toJavaString((byte[])buffer);
        try {
            zoneId = ZoneId.of(id);
        }
        catch (DateTimeException dateTimeException) {
            zoneId = ZoneId.systemDefault();
            TimeNatives.setTimeZoneId(SNI.toCString((String)zoneId.getId()));
        }
        return zoneId;
    }

    private static int getTimeZoneOffset(long time, ZoneId zoneId) {
        Instant instant = Instant.ofEpochMilli(time);
        ZoneOffset offset = zoneId.getRules().getOffset(instant);
        return offset.getTotalSeconds();
    }
}

