/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.services;

import com.microej.wear.kernel.natives.ExternalResourcesNatives;
import com.microej.wear.services.ExternalResourceService;
import ej.annotation.Nullable;
import ej.basictool.ArrayTools;
import ej.sni.SNI;
import java.io.IOException;
import java.util.Objects;

public class KernelExternalResourceService
implements ExternalResourceService {
    private static final String DECODE_PNG = "decode_png";
    private static final KernelExternalResourceService INSTANCE = new KernelExternalResourceService();

    private KernelExternalResourceService() {
    }

    public static KernelExternalResourceService getInstance() {
        return INSTANCE;
    }

    public ExternalResourceService.Writer createExternalResource(String path, int size) throws IOException {
        Objects.requireNonNull(path);
        int writerId = KernelExternalResourceService.createNativeResource(path, size, null, null);
        return new KernelWriter(writerId, size);
    }

    public ExternalResourceService.Writer createExternalImage(String path, int size, ExternalResourceService.ImageFormat format) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(format);
        int[] transformArgs = new int[]{KernelExternalResourceService.getFormatId(format)};
        int writerId = KernelExternalResourceService.createNativeResource(path, size, DECODE_PNG, transformArgs);
        return new KernelWriter(writerId, size);
    }

    public boolean deleteExternalResource(String path) throws IOException {
        Objects.requireNonNull(path);
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        byte[] cPath = SNI.toCString((String)path.substring(1));
        return ExternalResourcesNatives.delete(cPath);
    }

    public String getExternalResourcePath(String path) {
        return path;
    }

    private static int createNativeResource(String path, int size, @Nullable String transformName, @Nullable int[] transformArgs) throws IOException {
        if (!path.startsWith("/") || size < 0) {
            throw new IllegalArgumentException();
        }
        byte[] cPath = SNI.toCString((String)path.substring(1));
        byte[] cTransformName = transformName != null ? SNI.toCString((String)transformName) : null;
        return ExternalResourcesNatives.create(cPath, size, cTransformName, transformArgs);
    }

    private static int getFormatId(ExternalResourceService.ImageFormat format) {
        if (format == ExternalResourceService.ImageFormat.RGB565) {
            return 4;
        }
        if (format == ExternalResourceService.ImageFormat.ARGB4444) {
            return 6;
        }
        if (format == ExternalResourceService.ImageFormat.A8) {
            return 8;
        }
        throw new IllegalArgumentException();
    }

    private static class KernelWriter
    implements ExternalResourceService.Writer {
        private final int nativeId;
        private final int size;
        private boolean closed;

        public KernelWriter(int writerId, int size) {
            this.nativeId = writerId;
            this.size = size;
        }

        public synchronized void write(byte[] src, int srcOffset, int length, int destOffset) throws IOException {
            ArrayTools.checkBounds((byte[])src, (int)srcOffset, (int)length);
            if (destOffset < 0 || destOffset + length > this.size) {
                throw new IndexOutOfBoundsException();
            }
            if (this.closed) {
                throw new IllegalStateException();
            }
            ExternalResourcesNatives.write(this.nativeId, src, srcOffset, length, destOffset);
        }

        public synchronized void commit() throws IOException {
            if (this.closed) {
                throw new IllegalStateException();
            }
            try {
                ExternalResourcesNatives.commit(this.nativeId);
            }
            finally {
                this.close();
            }
        }

        public synchronized void close() {
            if (!this.closed) {
                this.closed = true;
                ExternalResourcesNatives.close(this.nativeId);
            }
        }
    }
}

