/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.services;

import com.microej.wear.kernel.natives.DeviceNatives;
import com.microej.wear.services.DeviceService;
import ej.bon.Constants;

public class KernelDeviceService
implements DeviceService {
    private static final String DEVICE_NAME_CONSTANT = "com.microej.wear.kernel.device.name";
    private static final int DEVICE_ADDRESS_LENGTH = 6;
    private static final char PADDING_CHAR = '0';
    private static final KernelDeviceService INSTANCE = new KernelDeviceService();

    private KernelDeviceService() {
    }

    public static KernelDeviceService getInstance() {
        return INSTANCE;
    }

    public int getBatteryLevel() {
        return DeviceNatives.getBatteryLevel();
    }

    public boolean isBatteryCharging() {
        return DeviceNatives.isBatteryCharging();
    }

    public String getDeviceName() {
        byte[] deviceAddress = KernelDeviceService.retrieveBluetoothAddress();
        String suffix = KernelDeviceService.toPaddedHex(deviceAddress[0]);
        return String.valueOf(Constants.getString((String)DEVICE_NAME_CONSTANT)) + ' ' + suffix;
    }

    public String getDeviceBluetoothAddress() {
        byte[] deviceAddress = KernelDeviceService.retrieveBluetoothAddress();
        StringBuilder sb = new StringBuilder();
        int i = 5;
        while (i > 0) {
            sb.append(KernelDeviceService.toPaddedHex(deviceAddress[i])).append(":");
            --i;
        }
        sb.append(KernelDeviceService.toPaddedHex(deviceAddress[0]));
        return sb.toString();
    }

    private static byte[] retrieveBluetoothAddress() {
        byte[] deviceAddress = new byte[6];
        DeviceNatives.getBluetoothAddress(deviceAddress);
        return deviceAddress;
    }

    private static String toPaddedHex(int value) {
        String suffix = Integer.toHexString(value & 0xFF).toUpperCase();
        if (suffix.length() < 2) {
            suffix = String.valueOf('0') + suffix;
        }
        return suffix;
    }
}

