/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.services;

import com.microej.wear.components.Activity;
import com.microej.wear.components.ComplicationDataSource;
import com.microej.wear.components.Navigator;
import com.microej.wear.components.Watchface;
import com.microej.wear.kernel.proxies.ActivityProxy;
import com.microej.wear.kernel.proxies.ComplicationDataSourceProxy;
import com.microej.wear.kernel.proxies.NavigatorProxy;
import com.microej.wear.kernel.proxies.Proxy;
import com.microej.wear.kernel.proxies.WatchfaceProxy;
import com.microej.wear.kernel.util.DefaultNavigator;
import com.microej.wear.kernel.util.ProxyArrayTools;
import com.microej.wear.services.ComponentService;
import ej.annotation.Nullable;
import ej.basictool.ArrayTools;
import ej.kf.Feature;
import ej.kf.FeatureStateListener;
import ej.kf.Kernel;
import java.util.Objects;

public class KernelComponentService
implements ComponentService {
    @Nullable
    private static KernelComponentService instance = new KernelComponentService();
    private NavigatorProxy navigator = KernelComponentService.createDefaultNavigator();
    private ActivityProxy[] activities = new ActivityProxy[0];
    private WatchfaceProxy[] watchfaces = new WatchfaceProxy[0];
    private ComplicationDataSourceProxy[] complicationDataSources = new ComplicationDataSourceProxy[0];

    private KernelComponentService() {
        Kernel.addFeatureStateListener((FeatureStateListener)new FeatureStateListener(){

            public void stateChanged(Feature feature, @Nullable Feature.State previousState) {
                if (feature.getState() == Feature.State.STOPPED) {
                    KernelComponentService.this.removeFeatureReferences(feature);
                }
            }
        });
    }

    public static KernelComponentService getInstance() {
        KernelComponentService instance = KernelComponentService.instance;
        if (instance == null) {
            KernelComponentService.instance = instance = new KernelComponentService();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNavigator(Navigator navigator) {
        Objects.requireNonNull(navigator);
        Kernel.enter();
        KernelComponentService kernelComponentService = this;
        synchronized (kernelComponentService) {
            NavigatorProxy oldNavigator = this.navigator;
            oldNavigator.removeReference();
            this.navigator = new NavigatorProxy(navigator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActivity(Activity activity) {
        Objects.requireNonNull(activity);
        Kernel.enter();
        ActivityProxy proxy = new ActivityProxy(activity);
        KernelComponentService kernelComponentService = this;
        synchronized (kernelComponentService) {
            this.activities = (ActivityProxy[])ArrayTools.add((Object[])this.activities, (Object)proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWatchface(Watchface watchface) {
        Objects.requireNonNull(watchface);
        Kernel.enter();
        WatchfaceProxy proxy = new WatchfaceProxy(watchface);
        KernelComponentService kernelComponentService = this;
        synchronized (kernelComponentService) {
            this.watchfaces = (WatchfaceProxy[])ArrayTools.insert((Object[])this.watchfaces, (int)0, (Object)proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerComplicationDataSource(ComplicationDataSource source) {
        Objects.requireNonNull(source);
        Kernel.enter();
        ComplicationDataSourceProxy proxy = new ComplicationDataSourceProxy(source);
        KernelComponentService kernelComponentService = this;
        synchronized (kernelComponentService) {
            this.complicationDataSources = (ComplicationDataSourceProxy[])ArrayTools.add((Object[])this.complicationDataSources, (Object)proxy);
        }
    }

    public Navigator getNavigator() {
        return this.navigator;
    }

    public Activity[] getActivities() {
        Kernel.enter();
        return (Activity[])this.activities.clone();
    }

    public Watchface[] getWatchfaces() {
        Kernel.enter();
        return (Watchface[])this.watchfaces.clone();
    }

    public ComplicationDataSource[] getComplicationDataSources() {
        Kernel.enter();
        return (ComplicationDataSource[])this.complicationDataSources.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFeatureReferences(Feature feature) {
        KernelComponentService kernelComponentService = this;
        synchronized (kernelComponentService) {
            NavigatorProxy navigator = this.navigator;
            if (navigator.isFeatureReference(feature)) {
                navigator.removeReference();
                this.navigator = KernelComponentService.createDefaultNavigator();
            }
            this.activities = (ActivityProxy[])ProxyArrayTools.removeFeatureReferences((Proxy[])this.activities, (Feature)feature);
            this.watchfaces = (WatchfaceProxy[])ProxyArrayTools.removeFeatureReferences((Proxy[])this.watchfaces, (Feature)feature);
            this.complicationDataSources = (ComplicationDataSourceProxy[])ProxyArrayTools.removeFeatureReferences((Proxy[])this.complicationDataSources, (Feature)feature);
        }
    }

    private static NavigatorProxy createDefaultNavigator() {
        return new NavigatorProxy(new DefaultNavigator());
    }
}

