/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.proxies;

import com.microej.wear.components.Renderable;
import com.microej.wear.components.Watchface;
import com.microej.wear.kernel.proxies.Proxy;
import com.microej.wear.kernel.proxies.RenderableProxy;
import com.microej.wear.kernel.util.EmptyRenderable;
import com.microej.wear.kernel.util.KernelUtils;
import com.microej.wear.kernel.util.UntrackedProxyManager;
import ej.annotation.Nullable;
import ej.kf.Kernel;
import ej.kf.Module;
import ej.microui.display.BufferedImage;
import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;
import ej.microui.display.Painter;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WatchfaceProxy
extends Proxy
implements Watchface {
    public WatchfaceProxy(Watchface watchface) {
        super(watchface);
    }

    @Nullable
    protected Watchface getObject() {
        return (Watchface)super.getObject();
    }

    public void onPreviewAttached() {
        Kernel.enter();
        Watchface watchface = this.getObject();
        if (watchface != null) {
            try {
                watchface.onPreviewAttached();
            }
            catch (Throwable e) {
                WatchfaceProxy.logException(e);
            }
        }
    }

    public void onPreviewDetached() {
        Kernel.enter();
        Watchface watchface = this.getObject();
        if (watchface != null) {
            try {
                watchface.onPreviewDetached();
            }
            catch (Throwable e) {
                WatchfaceProxy.logException(e);
            }
        }
    }

    public void renderPreview(GraphicsContext g, int x, int y, int size) {
        Objects.requireNonNull(g);
        Kernel.enter();
        Watchface watchface = this.getObject();
        if (watchface != null) {
            if (KernelUtils.isReferenceSafe(g, Kernel.getOwner((Object)watchface))) {
                try {
                    watchface.renderPreview(g, x, y, size);
                }
                catch (Throwable e) {
                    WatchfaceProxy.logException(e);
                }
            } else {
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedImage image = new BufferedImage(size, size);){
                    GraphicsContext imageGraphicsContext = image.getGraphicsContext();
                    Painter.drawDisplayRegion((GraphicsContext)imageGraphicsContext, (int)(x + g.getTranslationX()), (int)(y + g.getTranslationY()), (int)size, (int)size, (int)0, (int)0);
                    try {
                        watchface.renderPreview(imageGraphicsContext, 0, 0, size);
                    }
                    catch (Throwable e) {
                        WatchfaceProxy.logException(e);
                    }
                    Painter.drawImage((GraphicsContext)g, (Image)image, (int)x, (int)y);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    public Renderable createRenderable() {
        Module consumerModule = Kernel.getContextOwner();
        Kernel.enter();
        Watchface watchface = this.getObject();
        if (watchface != null) {
            Renderable renderable;
            try {
                renderable = watchface.createRenderable();
            }
            catch (Throwable e) {
                WatchfaceProxy.logException(e);
                return new EmptyRenderable();
            }
            if (KernelUtils.isReferenceSafe(renderable, consumerModule)) {
                return renderable;
            }
            RenderableProxy proxy = new RenderableProxy(renderable);
            UntrackedProxyManager.getInstance().add(proxy);
            return proxy;
        }
        return new EmptyRenderable();
    }

    private static void logException(Throwable e) {
        Logger.getAnonymousLogger().log(Level.WARNING, "Exception in Watchface", e);
    }
}

