/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.proxies;

import com.microej.wear.components.TimeConfigurationListener;
import com.microej.wear.kernel.proxies.Proxy;
import ej.annotation.Nullable;
import ej.kf.Kernel;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimeConfigurationListenerProxy
extends Proxy
implements TimeConfigurationListener {
    public TimeConfigurationListenerProxy(TimeConfigurationListener listener) {
        super(listener);
    }

    @Nullable
    protected TimeConfigurationListener getObject() {
        return (TimeConfigurationListener)super.getObject();
    }

    public void onTimeConfigurationChanged(long currentTime, String zoneId, int zoneOffset) {
        Objects.requireNonNull(zoneId);
        Kernel.enter();
        TimeConfigurationListener listener = this.getObject();
        if (listener != null) {
            try {
                listener.onTimeConfigurationChanged(currentTime, zoneId, zoneOffset);
            }
            catch (Throwable e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Exception in TimeConfigurationListener", e);
            }
        }
    }
}

