/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.proxies;

import com.microej.wear.components.Renderable;
import com.microej.wear.kernel.proxies.Proxy;
import com.microej.wear.kernel.util.KernelUtils;
import ej.annotation.Nullable;
import ej.kf.Kernel;
import ej.microui.display.BufferedImage;
import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;
import ej.microui.display.Painter;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RenderableProxy
extends Proxy
implements Renderable {
    public RenderableProxy(Renderable renderable) {
        super(renderable);
    }

    @Nullable
    protected Renderable getObject() {
        return (Renderable)super.getObject();
    }

    public void onAttached() {
        Kernel.enter();
        Renderable renderable = this.getObject();
        if (renderable != null) {
            try {
                renderable.onAttached();
            }
            catch (Throwable e) {
                RenderableProxy.logException(e);
            }
        }
    }

    public void onDetached() {
        Kernel.enter();
        Renderable renderable = this.getObject();
        if (renderable != null) {
            try {
                renderable.onDetached();
            }
            catch (Throwable e) {
                RenderableProxy.logException(e);
            }
        }
    }

    public void render(GraphicsContext g) {
        Objects.requireNonNull(g);
        Kernel.enter();
        Renderable renderable = this.getObject();
        if (renderable != null) {
            if (KernelUtils.isReferenceSafe(g, Kernel.getOwner((Object)renderable))) {
                try {
                    renderable.render(g);
                }
                catch (Throwable e) {
                    RenderableProxy.logException(e);
                }
            } else {
                int width = g.getWidth();
                int height = g.getHeight();
                Throwable throwable = null;
                Object var6_8 = null;
                try (BufferedImage image = new BufferedImage(width, height);){
                    GraphicsContext imageGraphicsContext = image.getGraphicsContext();
                    Painter.drawDisplayRegion((GraphicsContext)imageGraphicsContext, (int)g.getTranslationX(), (int)g.getTranslationY(), (int)width, (int)height, (int)0, (int)0);
                    try {
                        renderable.render(imageGraphicsContext);
                    }
                    catch (Throwable e) {
                        RenderableProxy.logException(e);
                    }
                    Painter.drawImage((GraphicsContext)g, (Image)image, (int)0, (int)0);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    public void showOnDisplay() {
        Kernel.enter();
        Renderable renderable = this.getObject();
        if (renderable != null) {
            try {
                renderable.showOnDisplay();
            }
            catch (Throwable e) {
                RenderableProxy.logException(e);
            }
        }
    }

    private static void logException(Throwable e) {
        Logger.getAnonymousLogger().log(Level.WARNING, "Exception in Renderable", e);
    }
}

