/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.proxies;

import com.microej.wear.components.ComplicationDataSource;
import com.microej.wear.kernel.proxies.Proxy;
import com.microej.wear.kernel.util.KernelUtils;
import ej.annotation.Nullable;
import ej.kf.Kernel;
import ej.kf.Module;
import ej.microui.display.BufferedImage;
import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;
import ej.microui.display.Painter;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComplicationDataSourceProxy
extends Proxy
implements ComplicationDataSource {
    private static final String DEFAULT_TEXT = "";

    public ComplicationDataSourceProxy(ComplicationDataSource source) {
        super(source);
    }

    @Nullable
    protected ComplicationDataSource getObject() {
        return (ComplicationDataSource)super.getObject();
    }

    public boolean hasText() {
        Kernel.enter();
        ComplicationDataSource source = this.getObject();
        if (source != null) {
            try {
                return source.hasText();
            }
            catch (Throwable e) {
                ComplicationDataSourceProxy.logException(e);
            }
        }
        return false;
    }

    public boolean hasIcon() {
        Kernel.enter();
        ComplicationDataSource source = this.getObject();
        if (source != null) {
            try {
                return source.hasIcon();
            }
            catch (Throwable e) {
                ComplicationDataSourceProxy.logException(e);
            }
        }
        return false;
    }

    public boolean hasProgress() {
        Kernel.enter();
        ComplicationDataSource source = this.getObject();
        if (source != null) {
            try {
                return source.hasProgress();
            }
            catch (Throwable e) {
                ComplicationDataSourceProxy.logException(e);
            }
        }
        return false;
    }

    public String getText() {
        Module consumerModule = Kernel.getContextOwner();
        Kernel.enter();
        ComplicationDataSource source = this.getObject();
        if (source != null) {
            String text;
            try {
                text = source.getText();
            }
            catch (Throwable e) {
                ComplicationDataSourceProxy.logException(e);
                return DEFAULT_TEXT;
            }
            if (KernelUtils.isReferenceSafe(text, consumerModule)) {
                return text;
            }
            return KernelUtils.cloneString(text, consumerModule);
        }
        return DEFAULT_TEXT;
    }

    public void onIconAttached() {
        Kernel.enter();
        ComplicationDataSource source = this.getObject();
        if (source != null) {
            try {
                source.onIconAttached();
            }
            catch (Throwable e) {
                ComplicationDataSourceProxy.logException(e);
            }
        }
    }

    public void onIconDetached() {
        Kernel.enter();
        ComplicationDataSource source = this.getObject();
        if (source != null) {
            try {
                source.onIconDetached();
            }
            catch (Throwable e) {
                ComplicationDataSourceProxy.logException(e);
            }
        }
    }

    public void renderIcon(GraphicsContext g, int x, int y, int width, int height) {
        Objects.requireNonNull(g);
        Kernel.enter();
        ComplicationDataSource source = this.getObject();
        if (source != null) {
            if (KernelUtils.isReferenceSafe(g, Kernel.getOwner((Object)source))) {
                source.renderIcon(g, x, y, width, height);
            } else {
                Throwable throwable = null;
                Object var8_9 = null;
                try (BufferedImage image = new BufferedImage(width, height);){
                    GraphicsContext imageGraphicsContext = image.getGraphicsContext();
                    Painter.drawDisplayRegion((GraphicsContext)imageGraphicsContext, (int)(x + g.getTranslationX()), (int)(y + g.getTranslationY()), (int)width, (int)height, (int)0, (int)0);
                    try {
                        source.renderIcon(imageGraphicsContext, 0, 0, width, height);
                    }
                    catch (Throwable e) {
                        ComplicationDataSourceProxy.logException(e);
                    }
                    Painter.drawImage((GraphicsContext)g, (Image)image, (int)x, (int)y);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    public float getProgress() {
        Kernel.enter();
        ComplicationDataSource source = this.getObject();
        if (source != null) {
            try {
                return source.getProgress();
            }
            catch (Throwable e) {
                ComplicationDataSourceProxy.logException(e);
            }
        }
        return 0.0f;
    }

    private static void logException(Throwable e) {
        Logger.getAnonymousLogger().log(Level.WARNING, "Exception in ComplicationDataSource", e);
    }
}

