/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.proxies;

import com.microej.wear.components.Activity;
import com.microej.wear.components.Renderable;
import com.microej.wear.kernel.proxies.Proxy;
import com.microej.wear.kernel.proxies.RenderableProxy;
import com.microej.wear.kernel.util.EmptyRenderable;
import com.microej.wear.kernel.util.KernelUtils;
import com.microej.wear.kernel.util.UntrackedProxyManager;
import ej.annotation.Nullable;
import ej.kf.Kernel;
import ej.kf.Module;
import ej.microui.display.BufferedImage;
import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;
import ej.microui.display.Painter;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActivityProxy
extends Proxy
implements Activity {
    private static final String DEFAULT_NAME = "";

    public ActivityProxy(Activity activity) {
        super(activity);
    }

    @Nullable
    protected Activity getObject() {
        return (Activity)super.getObject();
    }

    public String getName() {
        Module consumerModule = Kernel.getContextOwner();
        Kernel.enter();
        Activity activity = this.getObject();
        if (activity != null) {
            String name;
            try {
                name = activity.getName();
            }
            catch (Throwable e) {
                ActivityProxy.logException(e);
                return DEFAULT_NAME;
            }
            if (KernelUtils.isReferenceSafe(name, consumerModule)) {
                return name;
            }
            return KernelUtils.cloneString(name, consumerModule);
        }
        return DEFAULT_NAME;
    }

    public void onIconAttached() {
        Kernel.enter();
        Activity activity = this.getObject();
        if (activity != null) {
            try {
                activity.onIconAttached();
            }
            catch (Throwable e) {
                ActivityProxy.logException(e);
            }
        }
    }

    public void onIconDetached() {
        Kernel.enter();
        Activity activity = this.getObject();
        if (activity != null) {
            try {
                activity.onIconDetached();
            }
            catch (Throwable e) {
                ActivityProxy.logException(e);
            }
        }
    }

    public void renderIcon(GraphicsContext g, int x, int y, int size) {
        Objects.requireNonNull(g);
        Kernel.enter();
        Activity activity = this.getObject();
        if (activity != null) {
            if (KernelUtils.isReferenceSafe(g, Kernel.getOwner((Object)activity))) {
                try {
                    activity.renderIcon(g, x, y, size);
                }
                catch (Throwable e) {
                    ActivityProxy.logException(e);
                }
            } else {
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedImage image = new BufferedImage(size, size);){
                    GraphicsContext imageGraphicsContext = image.getGraphicsContext();
                    Painter.drawDisplayRegion((GraphicsContext)imageGraphicsContext, (int)(x + g.getTranslationX()), (int)(y + g.getTranslationY()), (int)size, (int)size, (int)0, (int)0);
                    try {
                        activity.renderIcon(imageGraphicsContext, 0, 0, size);
                    }
                    catch (Throwable e) {
                        ActivityProxy.logException(e);
                    }
                    Painter.drawImage((GraphicsContext)g, (Image)image, (int)x, (int)y);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    public Renderable createRenderable() {
        Module consumerModule = Kernel.getContextOwner();
        Kernel.enter();
        Activity activity = this.getObject();
        if (activity != null) {
            Renderable renderable;
            try {
                renderable = activity.createRenderable();
            }
            catch (Throwable e) {
                ActivityProxy.logException(e);
                return new EmptyRenderable();
            }
            if (KernelUtils.isReferenceSafe(renderable, consumerModule)) {
                return renderable;
            }
            RenderableProxy proxy = new RenderableProxy(renderable);
            UntrackedProxyManager.getInstance().add(proxy);
            return proxy;
        }
        return new EmptyRenderable();
    }

    private static void logException(Throwable e) {
        Logger.getAnonymousLogger().log(Level.WARNING, "Exception in Activity", e);
    }
}

