/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.companion;

import com.microej.wear.companion.server.CompanionHandler;
import com.microej.wear.companion.server.installfeature.InstallFeatureException;
import com.microej.wear.kernel.services.KernelTimeService;
import com.microej.wear.kernel.util.FeatureUtils;
import ej.basictool.ThreadUtils;
import ej.kf.AlreadyLoadedFeatureException;
import ej.kf.Feature;
import ej.kf.IncompatibleFeatureException;
import ej.kf.InvalidFormatException;
import ej.kf.Kernel;
import java.io.IOException;
import java.io.InputStream;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectCompanionHandler
implements CompanionHandler {
    private static final char[] HEX_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public void start() {
        Feature[] featureArray = Kernel.getAllLoadedFeatures();
        int n = featureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Feature installedFeature = featureArray[n2];
            installedFeature.start();
            ++n2;
        }
        ThreadUtils.sleep((long)500L);
    }

    public void setTimeConfiguration(long currentTime, String zoneIdString, int zoneOffset) {
        ZoneId zoneId;
        try {
            zoneId = ZoneId.of(zoneIdString);
        }
        catch (DateTimeException dateTimeException) {
            try {
                zoneId = ZoneOffset.ofTotalSeconds(zoneOffset);
            }
            catch (DateTimeException dateTimeException2) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Invalid zone ID");
                return;
            }
        }
        KernelTimeService.getInstance().setTimeConfiguration(currentTime, zoneId, zoneOffset);
    }

    public String[] getInstalledFeatures() {
        Feature[] features = Kernel.getAllLoadedFeatures();
        String[] featureUids = new String[features.length];
        int i = 0;
        while (i < features.length) {
            Feature installedFeature = features[i];
            assert (installedFeature != null);
            featureUids[i] = DirectCompanionHandler.getInstalledFeatureUid(installedFeature);
            ++i;
        }
        return featureUids;
    }

    public void uninstallFeature(String featureUid) throws IOException {
        Feature feature = null;
        Feature[] featureArray = Kernel.getAllLoadedFeatures();
        int n = featureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Feature installedFeature = featureArray[n2];
            assert (installedFeature != null);
            if (DirectCompanionHandler.getInstalledFeatureUid(installedFeature).equals(featureUid)) {
                feature = installedFeature;
                break;
            }
            ++n2;
        }
        if (feature == null) {
            throw new IOException("No Feature installed with this UID");
        }
        FeatureUtils.unloadInstalledFeature(feature);
    }

    public void beginFeatureInstall(String featureUid, int fileCount) throws IOException, InstallFeatureException {
        if (fileCount > 1) {
            throw new IOException("External resources not supported");
        }
        Feature feature = null;
        Feature[] featureArray = Kernel.getAllLoadedFeatures();
        int n = featureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Feature installedFeature = featureArray[n2];
            assert (installedFeature != null);
            if (DirectCompanionHandler.getInstalledFeatureUid(installedFeature).equals(featureUid)) {
                feature = installedFeature;
                break;
            }
            ++n2;
        }
        if (feature != null) {
            FeatureUtils.unloadInstalledFeature(feature);
        }
    }

    public void handleFeatureFile(String featureUid, int fileSize, String filePath, InputStream inputStream) throws IOException {
        if (!filePath.endsWith(".fo")) {
            throw new IOException("External resources not supported");
        }
        try {
            Kernel.load((InputStream)inputStream);
        }
        catch (AlreadyLoadedFeatureException | IncompatibleFeatureException | InvalidFormatException e) {
            throw new IOException(e);
        }
    }

    public void completeFeatureInstall(String featureUid) throws IOException {
    }

    public void stop() {
    }

    private static String getInstalledFeatureUid(Feature feature) {
        byte[] bytes = feature.getUID();
        int length = bytes.length;
        char[] chars = new char[length * 2];
        int i = 0;
        while (i < length) {
            int value = bytes[i] & 0xFF;
            chars[i * 2] = HEX_TABLE[value >> 4];
            chars[i * 2 + 1] = HEX_TABLE[value & 0xF];
            ++i;
        }
        return new String(chars);
    }
}

