/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.companion;

import com.microej.wear.KernelServiceProvider;
import com.microej.wear.companion.server.CompanionServer;
import ej.bluetooth.BluetoothAdapter;
import ej.bluetooth.BluetoothConnection;
import ej.bluetooth.listeners.ConnectionListener;
import ej.bluetooth.listeners.impl.DefaultConnectionListener;
import ej.bluetooth.util.AdvertisementData;
import ej.bon.Constants;

public class BluetoothConnectionManager
extends DefaultConnectionListener {
    private static final String DEVICE_MANUFACTURER_CONSTANT = "com.microej.wear.kernel.device.manufacturer.id";
    private final CompanionServer companionServer;

    public BluetoothConnectionManager(CompanionServer server) {
        this.companionServer = server;
    }

    public void start() {
        BluetoothAdapter.getAdapter().setConnectionListener((ConnectionListener)this);
        this.companionServer.start();
        BluetoothConnectionManager.startAdvertising();
    }

    public void onPairRequest(BluetoothConnection connection) {
        connection.sendPairResponse(true);
    }

    public void onDisconnected(BluetoothConnection connection) {
        BluetoothConnectionManager.startAdvertising();
    }

    private static void startAdvertising() {
        AdvertisementData advertisementData = new AdvertisementData();
        int manufacturerId = Constants.getInt((String)DEVICE_MANUFACTURER_CONSTANT) & 0xFFFF;
        advertisementData.addManufacturerData(manufacturerId, new byte[0]);
        advertisementData.setDeviceName(KernelServiceProvider.getDeviceService().getDeviceName());
        BluetoothAdapter adapter = BluetoothAdapter.getAdapter();
        adapter.startAdvertising(advertisementData.serialize());
    }
}

