/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel;

import com.microej.wear.KernelServiceProvider;
import com.microej.wear.companion.server.CompanionHandler;
import com.microej.wear.companion.server.CompanionServer;
import com.microej.wear.components.Watchface;
import com.microej.wear.kernel.companion.BluetoothConnectionManager;
import com.microej.wear.kernel.companion.DirectCompanionHandler;
import com.microej.wear.kernel.ui.DigitalWatchface;
import com.microej.wear.kernel.util.FeatureFileInputStream;
import ej.basictool.ThreadUtils;
import ej.bluetooth.BluetoothAdapter;
import ej.bluetooth.BluetoothService;
import ej.bluetooth.BluetoothServiceDefinition;
import ej.bluetooth.BluetoothUuid;
import ej.bluetooth.util.DescriptorHelper;
import ej.bon.Timer;
import ej.kf.AlreadyLoadedFeatureException;
import ej.kf.Feature;
import ej.kf.IncompatibleFeatureException;
import ej.kf.InvalidFormatException;
import ej.kf.Kernel;
import ej.microui.MicroUI;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Main {
    private static final long OPEN_FEATURE_FILE_RETRY_DELAY = 1000L;

    public static void main(String[] args) {
        MicroUI.start();
        BluetoothAdapter.getAdapter().enable();
        KernelServiceProvider.getComponentService().registerWatchface((Watchface)new DigitalWatchface());
        BluetoothService companionService = Main.setupCompanionService();
        DirectCompanionHandler companionHandler = new DirectCompanionHandler();
        Timer timer = KernelServiceProvider.getTimer();
        CompanionServer companionServer = new CompanionServer(companionService, (CompanionHandler)companionHandler, timer);
        BluetoothConnectionManager connectionManager = new BluetoothConnectionManager(companionServer);
        connectionManager.start();
        new DigitalWatchface().createRenderable().showOnDisplay();
        companionHandler.start();
        Main.loadDynamicFeatures();
    }

    private static BluetoothServiceDefinition getCompanionServiceDefinition() {
        BluetoothUuid serviceUuid = new BluetoothUuid("0FF5CE1F-7091-47A1-AC9F-7E1BD4406344");
        BluetoothServiceDefinition serviceDefinition = new BluetoothServiceDefinition(serviceUuid);
        BluetoothUuid m2wCharacteristicUuid = new BluetoothUuid("0FF5CE1F-7091-47A1-AC9F-7E1BD4406345");
        serviceDefinition.addCharacteristic(m2wCharacteristicUuid, 4, 16);
        BluetoothUuid w2mCharacteristicUuid = new BluetoothUuid("0FF5CE1F-7091-47A1-AC9F-7E1BD4406346");
        serviceDefinition.addCharacteristic(w2mCharacteristicUuid, 32, 2);
        serviceDefinition.addDescriptor(DescriptorHelper.CCC_UUID, 18);
        return serviceDefinition;
    }

    private static BluetoothService setupCompanionService() {
        BluetoothService service = BluetoothAdapter.getAdapter().addService(Main.getCompanionServiceDefinition());
        if (service == null) {
            throw new IllegalStateException();
        }
        return service;
    }

    private static void loadDynamicFeatures() {
        new Thread(){

            @Override
            public void run() {
                ThreadUtils.sleep((long)5000L);
                while (true) {
                    Main.loadFeature();
                }
            }
        }.start();
    }

    private static void loadFeature() {
        Feature feature;
        while (true) {
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try (FeatureFileInputStream inputStream = FeatureFileInputStream.open();){
                    if (inputStream != null) {
                        feature = Kernel.install((InputStream)inputStream);
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (AlreadyLoadedFeatureException | IncompatibleFeatureException | InvalidFormatException | IOException e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Error loading Feature", e);
            }
            ThreadUtils.sleep((long)1000L);
        }
        feature.start();
    }
}

