/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.mock.ui;

import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;

public abstract class HorizontalSliderSpinner
extends GridPane {
    private static final int LABEL_WIDTH = 70;
    private static final int SLIDER_WIDTH = 300;
    private static final int SPINNER_WIDTH = 80;

    protected HorizontalSliderSpinner(String label, int minValue, int maxValue, int initialValue) {
        Slider slider = new Slider((double)minValue, (double)maxValue, (double)initialValue);
        slider.setOrientation(Orientation.HORIZONTAL);
        slider.setShowTickLabels(true);
        slider.setMajorTickUnit((double)maxValue / 2.0);
        slider.setMinorTickCount(0);
        slider.setPadding(new Insets(0.0, 15.0, 0.0, 15.0));
        Spinner spinner = new Spinner();
        spinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(minValue, maxValue, initialValue));
        slider.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (((Integer)spinner.getValue()).intValue() != newValue.intValue()) {
                spinner.getValueFactory().setValue((Object)newValue.intValue());
                this.updateValue(newValue.intValue());
            }
        });
        spinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (slider.getValue() != newValue.doubleValue()) {
                slider.setValue(newValue.doubleValue());
                this.updateValue((int)newValue);
            }
        });
        initialValue = initialValue < minValue ? minValue : initialValue;
        initialValue = initialValue > maxValue ? maxValue : initialValue;
        spinner.getValueFactory().setValue((Object)initialValue);
        slider.setValue((double)initialValue);
        this.add((Node)new Label(label), 0, 0);
        this.add((Node)slider, 1, 0);
        this.add((Node)spinner, 2, 0);
        this.setAlignment(Pos.CENTER);
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setPrefWidth(70.0);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setPrefWidth(300.0);
        ColumnConstraints col3 = new ColumnConstraints();
        col3.setPrefWidth(80.0);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2, col3});
    }

    protected HorizontalSliderSpinner(String label, int minValue, int maxValue) {
        this(label, minValue, maxValue, minValue);
    }

    public abstract void updateValue(int var1);
}

