/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.mock.ui;

import com.microej.wear.kernel.natives.HealthNatives;
import com.microej.wear.kernel.natives.TimeNatives;
import com.microej.wear.mock.services.PowerService;
import com.microej.wear.mock.ui.HorizontalSliderSpinner;
import java.time.LocalDate;
import java.time.LocalTime;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class Dashboard {
    private static final String NORMAL = "Normal";

    public Dashboard(Pane rootPane) {
        ObservableList children = rootPane.getChildren();
        VBox rootBox = new VBox(10.0);
        rootBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Node powerLevel = this.createPowerLevel();
        Node timeManagement = this.createTimeManagement();
        Node stepsManagement = this.createHealthManagement();
        rootBox.getChildren().addAll((Object[])new Node[]{powerLevel, timeManagement, stepsManagement});
        children.add((Object)rootBox);
    }

    private Node createHealthManagement() {
        VBox vbox = new VBox(10.0);
        HorizontalSliderSpinner stepsHbox = new HorizontalSliderSpinner("Steps", 0, 20000, 2800){

            @Override
            public void updateValue(int newValue) {
                HealthNatives.setSteps(newValue);
            }
        };
        HorizontalSliderSpinner caloriesHbox = new HorizontalSliderSpinner("Calories", 0, 5000, 950){

            @Override
            public void updateValue(int newValue) {
                HealthNatives.setCalories(newValue);
            }
        };
        HorizontalSliderSpinner heartRateHbox = new HorizontalSliderSpinner("Heart rate", 0, 240, 120){

            @Override
            public void updateValue(int newValue) {
                HealthNatives.setHeartRate(newValue);
            }
        };
        HorizontalSliderSpinner spo2Hbox = new HorizontalSliderSpinner("SpO2", 0, 100, 90){

            @Override
            public void updateValue(int newValue) {
                HealthNatives.setOxygenSaturation(newValue);
            }
        };
        HorizontalSliderSpinner awakeSleepHbox = new HorizontalSliderSpinner("Awake Sleep", 0, 600, 30){

            @Override
            public void updateValue(int newValue) {
                HealthNatives.setAwakeSleepDuration(newValue);
            }
        };
        HorizontalSliderSpinner remSleepHbox = new HorizontalSliderSpinner("REM Sleep", 0, 600, 20){

            @Override
            public void updateValue(int newValue) {
                HealthNatives.setRemSleepDuration(newValue);
            }
        };
        HorizontalSliderSpinner lightSleepHbox = new HorizontalSliderSpinner("Light Sleep", 0, 600, 425){

            @Override
            public void updateValue(int newValue) {
                HealthNatives.setLightSleepDuration(newValue);
            }
        };
        HorizontalSliderSpinner deepSleepHbox = new HorizontalSliderSpinner("Deep Sleep", 0, 600, 62){

            @Override
            public void updateValue(int newValue) {
                HealthNatives.setDeepSleepDuration(newValue);
            }
        };
        vbox.getChildren().add((Object)stepsHbox);
        vbox.getChildren().add((Object)caloriesHbox);
        vbox.getChildren().add((Object)heartRateHbox);
        vbox.getChildren().add((Object)spo2Hbox);
        vbox.getChildren().add((Object)awakeSleepHbox);
        vbox.getChildren().add((Object)remSleepHbox);
        vbox.getChildren().add((Object)lightSleepHbox);
        vbox.getChildren().add((Object)deepSleepHbox);
        TitledPane pane = new TitledPane("Health", (Node)vbox);
        pane.setCollapsible(false);
        return pane;
    }

    private Node createTimeManagement() {
        VBox box = new VBox(10.0);
        TitledPane pane = new TitledPane("Time", (Node)box);
        pane.setCollapsible(false);
        Label dateLabel = new Label("Date:");
        dateLabel.setAlignment(Pos.CENTER);
        DatePicker datePicker = new DatePicker(LocalDate.now());
        datePicker.setOnAction(t -> {
            LocalDate newDate = (LocalDate)datePicker.getValue();
            TimeNatives.setDate(newDate);
        });
        HBox dateBox = new HBox(5.0, new Node[]{new StackPane(new Node[]{dateLabel}), datePicker});
        box.getChildren().add((Object)dateBox);
        HBox timeBox = new HBox(15.0);
        Label hourLabel = new Label("Hour:");
        Spinner hourSpinner = new Spinner();
        hourSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 23, LocalTime.now().getHour()));
        hourSpinner.valueProperty().addListener((observable, oldValue, newValue) -> TimeNatives.setHour(newValue));
        hourSpinner.setMaxWidth(80.0);
        timeBox.getChildren().add((Object)new HBox(5.0, new Node[]{new StackPane(new Node[]{hourLabel}), hourSpinner}));
        Label minuteLabel = new Label("Minute:");
        Spinner minuteSpinner = new Spinner();
        minuteSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 59, LocalTime.now().getMinute()));
        minuteSpinner.valueProperty().addListener((observable, oldValue, newValue) -> TimeNatives.setMinute(newValue));
        minuteSpinner.setMaxWidth(80.0);
        timeBox.getChildren().add((Object)new HBox(5.0, new Node[]{new StackPane(new Node[]{minuteLabel}), minuteSpinner}));
        Label secondLabel = new Label("Second:");
        Spinner secondSpinner = new Spinner();
        secondSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 59, LocalTime.now().getSecond()));
        secondSpinner.valueProperty().addListener((observable, oldValue, newValue) -> TimeNatives.setSecond(newValue));
        secondSpinner.setMaxWidth(80.0);
        timeBox.getChildren().add((Object)new HBox(5.0, new Node[]{new StackPane(new Node[]{secondLabel}), secondSpinner}));
        box.getChildren().add((Object)timeBox);
        HBox h = new HBox(5.0);
        Label label = new Label("Time Control:");
        label.setAlignment(Pos.CENTER);
        h.getChildren().add((Object)new StackPane(new Node[]{label}));
        ComboBox comboBox = new ComboBox();
        h.getChildren().add((Object)comboBox);
        box.getChildren().add((Object)h);
        comboBox.getItems().addAll((Object[])new String[]{NORMAL, "x60", "x3600", "x86400", "Paused"});
        comboBox.setOnAction(event -> {
            String selectedItem;
            switch (selectedItem = (String)comboBox.getSelectionModel().getSelectedItem()) {
                case "Normal": {
                    TimeNatives.setTimeSpeedup(1);
                    break;
                }
                case "x60": {
                    TimeNatives.setTimeSpeedup(60);
                    break;
                }
                case "x3600": {
                    TimeNatives.setTimeSpeedup(3600);
                    break;
                }
                case "x86400": {
                    TimeNatives.setTimeSpeedup(86400);
                    break;
                }
                case "Paused": {
                    TimeNatives.setTimeSpeedup(0);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown mode: " + selectedItem);
                }
            }
        });
        comboBox.setValue((Object)NORMAL);
        return pane;
    }

    private Node createPowerLevel() {
        VBox powerLeverlBox = new VBox(10.0);
        powerLeverlBox.setAlignment(Pos.TOP_CENTER);
        Label modeLabel = new Label("Battery Status:");
        ToggleGroup modeToggleGroup = new ToggleGroup();
        RadioButton modeCharge = new RadioButton("Charging");
        modeCharge.setToggleGroup(modeToggleGroup);
        RadioButton modeDischarge = new RadioButton("Discharging");
        modeDischarge.setToggleGroup(modeToggleGroup);
        modeDischarge.setSelected(true);
        HBox modeBox = new HBox(10.0);
        modeBox.getChildren().addAll((Object[])new Node[]{modeLabel, modeCharge, modeDischarge});
        Slider valueSlider = new Slider(0.0, 100.0, 80.0);
        valueSlider.setOrientation(Orientation.HORIZONTAL);
        valueSlider.setShowTickMarks(true);
        valueSlider.setShowTickLabels(true);
        valueSlider.setMajorTickUnit(25.0);
        valueSlider.setMinorTickCount(4);
        HBox.setHgrow((Node)valueSlider, (Priority)Priority.ALWAYS);
        Label valueLabel = new Label("Battery Level (%):");
        HBox valueBox = new HBox(10.0);
        valueBox.getChildren().addAll((Object[])new Node[]{valueLabel, valueSlider});
        powerLeverlBox.getChildren().addAll((Object[])new Node[]{modeBox, valueBox});
        TitledPane pane = new TitledPane("Power", (Node)powerLeverlBox);
        pane.setCollapsible(false);
        modeToggleGroup.selectedToggleProperty().addListener((observable, oldValue, newValue) -> PowerService.INSTANCE.setCharging(newValue == modeCharge));
        valueSlider.valueProperty().addListener((observable, oldValue, newValue) -> PowerService.INSTANCE.setPowerLevel(newValue.intValue()));
        PowerService.INSTANCE.getPowerProperty().addListener((observable, oldValue, newValue) -> valueSlider.setValue((double)newValue.intValue()));
        PowerService.INSTANCE.setPowerLevel((int)valueSlider.getValue());
        return pane;
    }
}

