/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.mock.services;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class RawImageHelper {
    private static final int IMAGE_HEADER_SIZE = 12;
    private static final byte[] SIGNATURE = new byte[]{77, 69, 74, 95, 73, 77, 71, 1};
    private static final int FORMAT_ARGB8888 = 2;
    private static final int FORMAT_RGB888 = 3;
    private static final int FORMAT_RGB565 = 4;
    private static final int FORMAT_ARGB4444 = 6;
    private static final int FORMAT_A8 = 8;
    private static final int FLAG_IS_OPAQUE = 4;

    private RawImageHelper() {
    }

    public static byte[] createRawImageData(int width, int height, int format, int[] pixelsData) {
        int bpp = RawImageHelper.getFormatBpp(format);
        ByteBuffer data = ByteBuffer.allocate(SIGNATURE.length + 12 + pixelsData.length * bpp);
        data.order(ByteOrder.LITTLE_ENDIAN);
        data.put(SIGNATURE);
        data.putShort((short)width);
        data.putShort((short)height);
        data.put((byte)format);
        data.put((byte)(RawImageHelper.isOpaqueFormat(format) ? 4 : 0));
        data.putShort((short)width);
        data.putShort((short)12);
        data.putShort((short)12);
        for (int color : pixelsData) {
            int r;
            int g;
            int b;
            if (format == 8) {
                data.put((byte)(color >> 24 & 0xFF));
                continue;
            }
            if (format == 4) {
                b = (color & 0xFF) >> 3;
                g = (color >> 8 & 0xFF) >> 2;
                r = (color >> 16 & 0xFF) >> 3;
                int rgb565 = r << 11 | g << 5 | b;
                data.put((byte)rgb565);
                data.put((byte)(rgb565 >> 8));
                continue;
            }
            if (format == 3) {
                data.put((byte)(color & 0xFF));
                data.put((byte)(color >> 8 & 0xFF));
                data.put((byte)(color >> 16 & 0xFF));
                continue;
            }
            if (format == 2) {
                data.put((byte)(color & 0xFF));
                data.put((byte)(color >> 8 & 0xFF));
                data.put((byte)(color >> 16 & 0xFF));
                data.put((byte)(color >> 24 & 0xFF));
                continue;
            }
            if (format == 6) {
                b = color & 0xFF;
                g = color >> 8 & 0xFF;
                r = color >> 16 & 0xFF;
                int a = color >> 24 & 0xFF;
                data.put((byte)(g & 0xF0 | b >> 4));
                data.put((byte)(a & 0xF0 | r >> 4));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return data.array();
    }

    private static int getFormatBpp(int format) {
        switch (format) {
            case 8: {
                return 1;
            }
            case 4: 
            case 6: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 2: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unsupported format " + format);
    }

    private static boolean isOpaqueFormat(int format) {
        switch (format) {
            case 2: 
            case 6: 
            case 8: {
                return false;
            }
            case 3: 
            case 4: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unsupported format " + format);
    }
}

