/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.mock.services;

import com.is2t.hil.HIL;
import java.util.Timer;
import java.util.TimerTask;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class PowerService {
    public static final PowerService INSTANCE = new PowerService();
    public static final int MIN_PERCENTAGE = 0;
    public static final int MAX_PERCENTAGE = 100;
    public static final int DEFAULT_POWER_LEVEL = 80;
    private static final long CHARGING_PERIOD = 5000L;
    private static final int CHARGING_STEP = 2;
    private static final int DISCHARGING_STEP = -1;
    private final IntegerProperty powerLevel = new SimpleIntegerProperty();
    private boolean charging;
    private final Timer timer = new Timer();

    private PowerService() {
        HIL.getInstance().addStopListener(isEvalVersion -> this.timer.cancel());
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                PowerService.this.updateCharge();
            }
        }, 0L, 5000L);
    }

    private void updateCharge() {
        int step = this.isCharging() ? 2 : -1;
        this.setPowerLevel(step + this.getPowerLevel());
    }

    public IntegerProperty getPowerProperty() {
        return this.powerLevel;
    }

    public int getPowerLevel() {
        return this.powerLevel.get();
    }

    public void setPowerLevel(int powerLevel) {
        if (powerLevel < 0) {
            this.powerLevel.set(0);
        } else if (powerLevel > 100) {
            this.powerLevel.set(100);
        } else {
            this.powerLevel.set(powerLevel);
        }
    }

    public boolean isCharging() {
        return this.charging;
    }

    public void setCharging(boolean charging) {
        this.charging = charging;
    }
}

