/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.mock.services;

import com.microej.wear.mock.services.RawImageHelper;
import ej.sni.NativeIOException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ExternalResourcesManager {
    private static final String DIR_PROPERTY = "externalResources.output.dir";
    private static final String DECODE_PNG = "decode_png";
    private static final int LLEXT_RES_WRITER_UNKNOWN_ERROR = -1;
    private static final int LLEXT_RES_WRITER_ERROR_CONVERSION_ERROR = -3;
    private static final int LLEXT_RES_WRITER_RESOURCE_IN_USE = -5;
    private static final int LLEXT_RES_WRITER_RESOURCE_EXISTS = -6;
    private static Map<Integer, ResourceWriter> writers = new HashMap<Integer, ResourceWriter>();
    private static int currentWriterId = 0;

    private ExternalResourcesManager() {
    }

    public static int createExternalResource(String path, int size, String conversionName, int[] conversionParameters) throws NativeIOException {
        ExternalResourcesManager.checkArguments(conversionName, conversionParameters);
        File file = ExternalResourcesManager.getExternalResourceFile(path);
        if (file.exists()) {
            throw new NativeIOException(-6, "File already exists");
        }
        if (ExternalResourcesManager.writerExists(file)) {
            throw new NativeIOException(-5, "Resource already opened in a writer");
        }
        int id = currentWriterId++;
        ResourceWriter writer = new ResourceWriter(file, size, conversionName, conversionParameters);
        writers.put(id, writer);
        return id;
    }

    public static void write(int writerId, byte[] src, int srcOffset, int length, int destOffset) {
        ResourceWriter writer = writers.get(writerId);
        System.arraycopy(src, srcOffset, writer.buffer, destOffset, length);
    }

    public static void commit(int writerId) throws NativeIOException {
        ResourceWriter writer = writers.get(writerId);
        Path path = writer.file.toPath();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new NativeIOException(-1, "An error occurred while creating the file");
        }
        if (DECODE_PNG.equals(writer.conversionName)) {
            int imageFormat = writer.conversionParameters[0];
            byte[] imageData = ExternalResourcesManager.convertToImage(writer.buffer, imageFormat);
            try {
                Files.write(path, imageData, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new NativeIOException(-1, "An error occurred while writing to the file");
            }
        }
        try {
            Files.write(path, writer.buffer, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new NativeIOException(-1, "An error occurred while writing to the file");
        }
        Logger.getAnonymousLogger().info("External resource successfully saved to file");
    }

    private static byte[] convertToImage(byte[] fileData, int imageFormat) throws NativeIOException {
        try {
            BufferedImage awtImage = ImageIO.read(new ByteArrayInputStream(fileData, 0, fileData.length));
            int width = awtImage.getWidth();
            int height = awtImage.getHeight();
            int[] pixelsData = new int[width * height];
            awtImage.getRGB(0, 0, width, height, pixelsData, 0, width);
            return RawImageHelper.createRawImageData(width, height, imageFormat, pixelsData);
        }
        catch (IOException e) {
            throw new NativeIOException(-3, "An error occurred while decoding the image");
        }
    }

    public static void close(int writerId) {
        writers.remove(writerId);
    }

    public static void deleteExternalResources(String path) throws NativeIOException {
        File file = ExternalResourcesManager.getExternalResourceFile(path);
        if (ExternalResourcesManager.writerExists(file)) {
            throw new NativeIOException(-5, "Cannot delete a resource opened in a writer");
        }
        try {
            ExternalResourcesManager.deleteFile(file);
        }
        catch (IOException e) {
            throw new NativeIOException(-1, "Could not delete file");
        }
    }

    private static boolean writerExists(File file) {
        return writers.values().stream().anyMatch(writer -> {
            try {
                return Files.isSameFile(writer.file.toPath(), file.toPath());
            }
            catch (IOException e) {
                return false;
            }
        });
    }

    private static void deleteFile(File file) throws IOException {
        Path filePath = file.toPath();
        try {
            Files.delete(filePath);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    public static File getExternalResourceFile(String path) {
        return new File(ExternalResourcesManager.getDirectory(), path);
    }

    private static File getDirectory() {
        String path = System.getProperty(DIR_PROPERTY);
        if (path == null) {
            throw new IllegalArgumentException("Property externalResources.output.dir is not set");
        }
        File directory = new File(path);
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("Property externalResources.output.dir does not point to a valid directory");
        }
        return directory;
    }

    private static void checkArguments(String conversionName, int[] conversionParameters) throws NativeIOException {
        if (conversionName != null) {
            if (DECODE_PNG.equals(conversionName)) {
                if (conversionParameters.length != 1) {
                    throw new NativeIOException(-3, "Unexpected number of conversion parameters");
                }
            } else {
                throw new NativeIOException(-3, "Unknown conversion name");
            }
        }
    }

    private static class ResourceWriter {
        private final File file;
        private final byte[] buffer;
        private final String conversionName;
        private final int[] conversionParameters;

        private ResourceWriter(File file, int size, String conversionName, int[] conversionParameters) {
            this.file = file;
            this.buffer = new byte[size];
            this.conversionName = conversionName;
            this.conversionParameters = conversionParameters;
        }
    }
}

