/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.natives;

import ej.sni.SNI;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class TimeNatives {
    private static final int SLEEP_DURATION = 10;
    private static volatile long currentTimeMillis;
    private static ZoneId currentZoneId;
    private static volatile int timeSpeedupRate;
    private static TimeThread thread;

    private TimeNatives() {
    }

    public static void setTimeSpeedup(int rate) {
        timeSpeedupRate = rate;
    }

    public static long getCurrentTime() {
        return currentTimeMillis;
    }

    public static void setCurrentTime(long currentTime) {
        TimeNatives.setMillis(currentTime);
    }

    public static void getTimeZoneId(byte[] buffer) {
        String id = currentZoneId.getId();
        SNI.toCString((String)id, (byte[])buffer);
    }

    public static void setTimeZoneId(byte[] buffer) {
        String id = SNI.toJavaString((byte[])buffer);
        currentZoneId = ZoneId.of(id);
    }

    public static synchronized void setMillis(long millis) {
        currentTimeMillis = millis;
    }

    public static void setHour(int newHour) {
        if (newHour < 0 || newHour > 23) {
            throw new IllegalArgumentException("Invalid hour: " + newHour);
        }
        ZonedDateTime dateTime = TimeNatives.getDateTime(currentTimeMillis, currentZoneId);
        dateTime = dateTime.withHour(newHour);
        TimeNatives.setMillis(dateTime.toInstant().toEpochMilli());
    }

    public static void setMinute(int newMinute) {
        if (newMinute < 0 || newMinute > 59) {
            throw new IllegalArgumentException("Invalid minute: " + newMinute);
        }
        ZonedDateTime dateTime = TimeNatives.getDateTime(currentTimeMillis, currentZoneId);
        dateTime = dateTime.withMinute(newMinute);
        TimeNatives.setMillis(dateTime.toInstant().toEpochMilli());
    }

    public static void setSecond(int newSecond) {
        if (newSecond < 0 || newSecond > 59) {
            throw new IllegalArgumentException("Invalid second: " + newSecond);
        }
        ZonedDateTime dateTime = TimeNatives.getDateTime(currentTimeMillis, currentZoneId);
        dateTime = dateTime.withSecond(newSecond);
        TimeNatives.setMillis(dateTime.toInstant().toEpochMilli());
    }

    public static void setDate(LocalDate date) {
        Instant instant = Instant.ofEpochMilli(currentTimeMillis);
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(instant, currentZoneId);
        dateTime = dateTime.with(date);
        TimeNatives.setMillis(dateTime.toInstant().toEpochMilli());
    }

    private static ZonedDateTime getDateTime(long currentTime, ZoneId zoneId) {
        Instant instant = Instant.ofEpochMilli(currentTime);
        return ZonedDateTime.ofInstant(instant, zoneId);
    }

    static {
        currentZoneId = ZonedDateTime.now().getOffset();
        ZonedDateTime dateTime = TimeNatives.getDateTime(System.currentTimeMillis(), currentZoneId);
        TimeNatives.setMillis(dateTime.toInstant().toEpochMilli());
        timeSpeedupRate = 1;
        thread = new TimeThread();
        thread.start();
    }

    private static class TimeThread
    extends Thread {
        public TimeThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                long sleepStartTime = System.currentTimeMillis();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    TimeThread.currentThread().interrupt();
                    return;
                }
                TimeNatives.setMillis(TimeNatives.getCurrentTime() + (System.currentTimeMillis() - sleepStartTime) * (long)timeSpeedupRate);
            }
        }
    }
}

