/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.kernel.natives;

import com.is2t.hil.HIL;
import com.microej.wear.mock.services.ExternalResourcesManager;
import ej.sni.NativeIOException;
import ej.sni.SNI;

public class ExternalResourcesNatives {
    private ExternalResourcesNatives() {
    }

    public static int create(byte[] pathArray, int size, byte[] conversionNameArray, int[] conversionParametersArray) throws NativeIOException {
        String path = SNI.toJavaString((byte[])pathArray);
        if (conversionParametersArray != null) {
            HIL.getInstance().refreshContent((Object)conversionParametersArray);
        }
        String conversionName = conversionNameArray != null ? SNI.toJavaString((byte[])conversionNameArray) : null;
        return ExternalResourcesManager.createExternalResource(path, size, conversionName, conversionParametersArray);
    }

    public static void write(int writerId, byte[] src, int srcOffset, int length, int destOffset) {
        HIL.getInstance().refreshContent((Object)src, srcOffset, length);
        ExternalResourcesManager.write(writerId, src, srcOffset, length, destOffset);
    }

    public static void commit(int writerId) throws NativeIOException {
        ExternalResourcesManager.commit(writerId);
    }

    public static void close(int writerId) {
        ExternalResourcesManager.close(writerId);
    }

    public static void delete(byte[] pathArray) throws NativeIOException {
        HIL.getInstance().refreshContent((Object)pathArray);
        String path = SNI.toJavaString((byte[])pathArray);
        ExternalResourcesManager.deleteExternalResources(path);
    }
}

