/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.tools.deploy;

import com.is2t.microej.workbench.extension.Page;
import com.is2t.microej.workbench.extension.PagesResolver;
import com.is2t.microej.workbench.std.launch.ext.BrowseOption;
import com.is2t.microej.workbench.std.launch.ext.CheckBoxOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.HiddenOption;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.LabelOption;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.StringLabel;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.CheckBoxSelected;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import com.is2t.microej.workbench.std.launch.ext.expr.UnaryExpression;
import com.is2t.microej.workbench.std.launch.ext.expr.VMConfiguration;
import com.is2t.microej.workbench.std.launch.ext.validator.FileOptionValidator;
import com.is2t.tools.deploy.DevicePage;
import com.is2t.tools.deploy.Messages;
import java.util.ArrayList;
import java.util.Properties;

public class DeployPage
implements Page {
    private static final String SCRIPT_PROPERTY = "deploy.script";
    private static final String SCRIPT_BSP = "deployInBSP.xml";
    private static final String DEPLOY_INPUT_PROPERTIES_FILE = "deployInBSP.properties";
    private static final String DEPLOY_INPUT_PROPERTY_IN_BSP = "deploy.bsp.available";
    private static final String DEPLOY_INPUT_PROPERTY_RELATIVE_DIR_APP = "deploy.bsp.microejapp.relative.dir";
    private static final String DEPLOY_INPUT_PROPERTY_RELATIVE_DIR_LIB = "deploy.bsp.microejlib.relative.dir";
    private static final String DEPLOY_INPUT_PROPERTY_RELATIVE_DIR_INC = "deploy.bsp.microejinc.relative.dir";
    private static final String OUTPUT_PROPERTY_PREFIX_BSP = "deploy.bsp.";
    private static final String OUTPUT_PROPERTY_PREFIX_DIR = "deploy.dir.";
    private static final String OUTPUT_PROPERTY_SUFFIX_MICROEJAPP = "microejapp";
    private static final String OUTPUT_PROPERTY_SUFFIX_MICROEJLIB = "microejlib";
    private static final String OUTPUT_PROPERTY_SUFFIX_MICROEJINC = "microejinc";
    private static final String OUTPUT_PROPERTY_SUFFIX_MICROEJSCRIPT = "microejscript";
    private static final String OUTPUT_PROPERTY_BSP_ROOT_DIR = "deploy.bsp.root.dir";
    private final Properties deployProperties = this.newProperties();
    private final boolean deployInBSP = this.getBooleanProperty("deploy.bsp.available");

    public String getParent() {
        return DevicePage.class.getName();
    }

    public String getName() {
        return Messages.CategoryDeploy;
    }

    public Description getDescription() {
        return new XHTMLDescription(Messages.DDCategoryDeploy);
    }

    public PageContent getContent() {
        boolean wellKnownLocationSupport = this.deployInBSP;
        ArrayList<Object> pageContentVect = new ArrayList<Object>();
        HiddenOption deployProperty = new HiddenOption("", SCRIPT_PROPERTY, SCRIPT_BSP);
        pageContentVect.add(deployProperty);
        Group microejapp = this.copyPlatformFilesGetDirGroup(this.deployInBSP, wellKnownLocationSupport ? this.isPropertySet(DEPLOY_INPUT_PROPERTY_RELATIVE_DIR_APP) : true, Messages.CheckLabelMicroejappDeployInBSP, Messages.CheckDescMicroejappDeployInBSP, Messages.DirLabelMicroejappDeployInBSP, Messages.DirDescMicroejappDeployInBSP, OUTPUT_PROPERTY_SUFFIX_MICROEJAPP);
        pageContentVect.add(microejapp);
        Group microejlib = this.copyPlatformFilesGetDirGroup(wellKnownLocationSupport, wellKnownLocationSupport ? this.isPropertySet(DEPLOY_INPUT_PROPERTY_RELATIVE_DIR_LIB) : false, Messages.CheckLabelMicroejlibDeployInBSP, Messages.CheckDescMicroejlibDeployInBSP, Messages.DirLabelMicroejlibDeployInBSP, Messages.DirDescMicroejincDeployInBSP, OUTPUT_PROPERTY_SUFFIX_MICROEJLIB);
        pageContentVect.add(microejlib);
        Group microejinc = this.copyPlatformFilesGetDirGroup(wellKnownLocationSupport, wellKnownLocationSupport ? this.isPropertySet(DEPLOY_INPUT_PROPERTY_RELATIVE_DIR_INC) : false, Messages.CheckLabelMicroejincDeployInBSP, Messages.CheckDescMicroejincDeployInBSP, Messages.DirLabelMicroejincDeployInBSP, Messages.DirDescMicroejincDeployInBSP, OUTPUT_PROPERTY_SUFFIX_MICROEJINC);
        pageContentVect.add(microejinc);
        Group microejscript = this.copyPlatformFilesGetDirGroup(wellKnownLocationSupport, false, Messages.CheckLabelMicroejscriptDeployInBSP, Messages.CheckDescMicroejscriptDeployInBSP, Messages.DirLabelMicroejscriptDeployInBSP, Messages.DirDescMicroejscriptDeployInBSP, OUTPUT_PROPERTY_SUFFIX_MICROEJSCRIPT);
        pageContentVect.add(microejscript);
        if (wellKnownLocationSupport) {
            LabelOption labelOption = new LabelOption(Messages.DirLabelBSPRoot);
            BrowseOption browseOption = new BrowseOption((ILabel)new StringLabel(""), OUTPUT_PROPERTY_BSP_ROOT_DIR, Messages.DeployBrowse, Messages.DeployBrowseDirTitle, null);
            browseOption.fileMustExist(false);
            browseOption.emptyFileIsValid(true);
            browseOption.setInitialValue("");
            browseOption.setOptionValidator((OptionValidator)new FileOptionValidator(Messages.DeployBrowseDirLabel, false, true, false, false, true));
            browseOption.setDescription((Description)new XHTMLDescription(Messages.DirDescBSPRoot));
            Group bspRootDir = new Group(new PageContent[]{labelOption, browseOption}, 1);
            pageContentVect.add(bspRootDir);
        }
        return new LabelGroup(Messages.GroupDeploy, pageContentVect.toArray(new PageContent[pageContentVect.size()]), 1);
    }

    private Group copyPlatformFilesGetDirGroup(boolean addCheck, boolean checkDefaultValue, String checkLabel, String checkDesc, String label, String desc, String propSuffix) {
        HiddenOption defaultOption;
        LabelOption labelOption = new LabelOption(label);
        BrowseOption browseOption = new BrowseOption((ILabel)new StringLabel(""), OUTPUT_PROPERTY_PREFIX_DIR + propSuffix, Messages.DeployBrowse, Messages.DeployBrowseDirTitle, null);
        browseOption.fileMustExist(false);
        browseOption.emptyFileIsValid(true);
        browseOption.setInitialValue("");
        browseOption.setOptionValidator((OptionValidator)new FileOptionValidator(Messages.DeployBrowseDirLabel, false, true, false, false, true));
        browseOption.setDescription((Description)new XHTMLDescription(desc));
        if (addCheck) {
            CheckBoxOption checkOption = new CheckBoxOption((ILabel)new StringLabel(checkLabel), OUTPUT_PROPERTY_PREFIX_BSP + propSuffix);
            checkOption.setDescription((Description)new XHTMLDescription(checkDesc));
            checkOption.setInitialValue(checkDefaultValue);
            browseOption.setEnableCondition((Expression)new UnaryExpression(1, (Expression)new CheckBoxSelected(checkOption)));
            labelOption.setEnableCondition((Expression)new UnaryExpression(1, (Expression)new CheckBoxSelected(checkOption)));
            defaultOption = checkOption;
        } else {
            defaultOption = new HiddenOption("", OUTPUT_PROPERTY_PREFIX_BSP + propSuffix, Boolean.FALSE.toString());
        }
        return new Group(new PageContent[]{defaultOption, labelOption, browseOption}, 1);
    }

    public void finalize(PagesResolver resolver) {
    }

    public Expression getVisibility() {
        return new UnaryExpression(1, (Expression)new VMConfiguration(VMConfiguration.S3));
    }

    private Properties newProperties() {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("/deployInBSP.properties"));
            return properties;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isPropertySet(String prop) {
        try {
            return this.deployProperties.getProperty(prop) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean getBooleanProperty(String prop) {
        try {
            return this.deployProperties.getProperty(prop).trim().equals("true");
        }
        catch (Exception e) {
            return false;
        }
    }
}

