/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microui.font.extension;

import com.is2t.microej.workbench.extension.Page;
import com.is2t.microej.workbench.extension.PagesResolver;
import com.is2t.microej.workbench.std.launch.ext.BrowseOption;
import com.is2t.microej.workbench.std.launch.ext.CheckBoxOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.InputOption;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.LabelOption;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.StringLabel;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.BinaryExpression;
import com.is2t.microej.workbench.std.launch.ext.expr.CheckBoxSelected;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import com.is2t.microej.workbench.std.launch.ext.validator.FileOptionValidator;
import com.is2t.microui.font.extension.MicroUIFontMessages;
import java.util.ArrayList;
import java.util.Properties;

public class FontPage
implements Page {
    private static final String PROPERTIES_FILE = "fontgen.properties";
    private static final String PROPERTY_EXTERNAL_RESOURCES = "external.resources";
    public static final String PROPERTY_MicroUISupportFontsFile = "ej.microui.fontConverter.file";
    private static final String PROPERTY_MicroUISupportFontsFileExternal = "ej.microui.fontConverter.file.external";
    public static final String PROPERTY_MicroUISupportFontsPlatform = "ej.microui.fontConverter.platform";
    public static final String PROPERTY_MicroUISupportFontConvertFont = "ej.microui.fontConverter.useIt";

    public PageContent getContent() {
        return this.buildMicroUIFontGroup();
    }

    public String getName() {
        return MicroUIFontMessages.CategoryFont;
    }

    public String getParent() {
        return "com.is2t.microui.extension.MicroUIPage";
    }

    public Expression getVisibility() {
        return null;
    }

    public Description getDescription() {
        return null;
    }

    public void finalize(PagesResolver pagesResolver) {
    }

    public Group buildMicroUIFontGroup() {
        ArrayList<InputOption> arrayList = new ArrayList<InputOption>();
        LabelOption labelOption = new LabelOption(MicroUIFontMessages.LabelPresentation);
        arrayList.add((InputOption)labelOption);
        CheckBoxOption checkBoxOption = new CheckBoxOption((ILabel)new StringLabel(MicroUIFontMessages.LabelCheckbox), PROPERTY_MicroUISupportFontConvertFont);
        checkBoxOption.setInitialValue(true);
        checkBoxOption.setDescription((Description)new XHTMLDescription(MicroUIFontMessages.DescriptionCheckbox));
        arrayList.add((InputOption)checkBoxOption);
        this.addListOption(arrayList, checkBoxOption, MicroUIFontMessages.LabelListInternal, PROPERTY_MicroUISupportFontsFile);
        this.addExternalResourcesOption(arrayList, checkBoxOption);
        PageContent[] pageContentArray = arrayList.toArray(new PageContent[0]);
        LabelGroup labelGroup = new LabelGroup(MicroUIFontMessages.LabelGroup, pageContentArray, 1);
        labelGroup.setDescription((Description)new XHTMLDescription(MicroUIFontMessages.DescriptionGroupFont));
        return labelGroup;
    }

    private void addExternalResourcesOption(ArrayList<InputOption> arrayList, CheckBoxOption checkBoxOption) {
        try {
            Properties properties = new Properties();
            properties.load(FontPage.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE));
            if (properties.getProperty(PROPERTY_EXTERNAL_RESOURCES).trim().toLowerCase().equals(Boolean.TRUE.toString())) {
                this.addListOption(arrayList, checkBoxOption, MicroUIFontMessages.LabelListExternal, PROPERTY_MicroUISupportFontsFileExternal);
            }
        }
        catch (Exception exception) {}
    }

    private void addListOption(ArrayList<InputOption> arrayList, CheckBoxOption checkBoxOption, String string, String string2) {
        LabelOption labelOption = new LabelOption(string);
        arrayList.add((InputOption)labelOption);
        CheckBoxOption checkBoxOption2 = new CheckBoxOption((ILabel)new StringLabel(MicroUIFontMessages.LabelCheckboxExplicitListFile), String.valueOf(string2) + ".enabled");
        checkBoxOption2.setInitialValue(false);
        checkBoxOption2.setDescription((Description)new XHTMLDescription(MicroUIFontMessages.DescriptionCheckboxExplicitListFile));
        checkBoxOption2.setEnableCondition((Expression)new CheckBoxSelected(checkBoxOption));
        arrayList.add((InputOption)checkBoxOption2);
        BrowseOption browseOption = new BrowseOption((ILabel)new StringLabel(""), string2, MicroUIFontMessages.LabelButtonBrowse, MicroUIFontMessages.LabelBrowse, new String[]{"*.list", "*.*"});
        browseOption.setInitialValue("");
        browseOption.setOptionValidator((OptionValidator)new FileOptionValidator(MicroUIFontMessages.LabelListInternal, true, false, true, false));
        browseOption.setDescription((Description)new XHTMLDescription(MicroUIFontMessages.DescriptionListFile));
        browseOption.setEnableCondition((Expression)new BinaryExpression(3, (Expression)new CheckBoxSelected(checkBoxOption), (Expression)new CheckBoxSelected(checkBoxOption2)));
        browseOption.emptyFileIsValid(true);
        browseOption.fileMustExist(true);
        arrayList.add((InputOption)browseOption);
    }
}

