/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.companion.server.installfeature;

import com.microej.wear.companion.server.installfeature.DeployFileController;
import com.microej.wear.companion.server.installfeature.InstallFeatureException;
import com.microej.wear.companion.server.installfeature.InstallFeatureListener;
import ej.annotation.Nullable;
import java.io.IOException;

public class InstallFeatureController {
    private final int installationId;
    private final String featureUid;
    private final int totalFileCount;
    private final InstallFeatureListener listener;
    @Nullable
    private DeployFileController currentFileController;
    private int currentFileIndex;

    public InstallFeatureController(int installationId, String featureUid, int fileCount, InstallFeatureListener listener) {
        this.installationId = installationId;
        this.featureUid = featureUid;
        this.totalFileCount = fileCount;
        this.listener = listener;
        this.currentFileController = null;
        this.currentFileIndex = 0;
    }

    public void stop() {
        DeployFileController fileController = this.currentFileController;
        if (fileController != null) {
            fileController.stop();
            this.currentFileController = null;
        }
    }

    public void onFileChunk(int installationId, int fileIndex, int sequenceNumber, byte[] chunk) throws InstallFeatureException {
        if (installationId != this.installationId) {
            throw new InstallFeatureException(100);
        }
        DeployFileController fileController = this.currentFileController;
        if (fileController == null) {
            throw new InstallFeatureException(3);
        }
        if (fileIndex != this.currentFileIndex) {
            throw new InstallFeatureException(106);
        }
        fileController.onFileChunk(sequenceNumber, chunk);
    }

    public void onStartOfFile(int installationId, int fileIndex, int fileSize, String filePath) throws InstallFeatureException {
        if (installationId != this.installationId) {
            throw new InstallFeatureException(100);
        }
        if (fileIndex != this.currentFileIndex) {
            throw new InstallFeatureException(106);
        }
        DeployFileController fileController = this.currentFileController;
        if (fileController != null) {
            throw new InstallFeatureException(3);
        }
        fileController = new DeployFileController(installationId, this.featureUid, fileIndex, fileSize, filePath, this.listener);
        fileController.start();
        this.currentFileController = fileController;
    }

    public void onEndOfFile(int installationId, int fileIndex, long checksum) throws InstallFeatureException {
        if (installationId != this.installationId) {
            throw new InstallFeatureException(100);
        }
        DeployFileController fileController = this.currentFileController;
        if (fileController == null) {
            throw new InstallFeatureException(3);
        }
        if (fileIndex != this.currentFileIndex) {
            throw new InstallFeatureException(106);
        }
        fileController.onEndOfFile(checksum);
        fileController.stop();
        this.currentFileController = null;
        ++this.currentFileIndex;
    }

    public void onEndOfFeature(int installationId) throws InstallFeatureException {
        if (installationId != this.installationId) {
            throw new InstallFeatureException(100);
        }
        if (this.currentFileIndex != this.totalFileCount) {
            throw new InstallFeatureException(107);
        }
        try {
            this.listener.completeFeatureInstall(this.featureUid);
        }
        catch (IOException e) {
            throw new InstallFeatureException(103, e);
        }
    }
}

