/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.companion.server.installfeature;

import com.microej.wear.companion.server.CompanionServer;
import com.microej.wear.companion.server.installfeature.Checksum;
import com.microej.wear.companion.server.installfeature.InstallFeatureException;
import com.microej.wear.companion.server.installfeature.InstallFeatureListener;
import ej.bon.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeployFileController {
    private static final int INSTALL_BUFFER_SIZE = 512;
    private final Thread chunkConsumerThread;
    private final Thread chunkProducerThread;
    private final PipedInputStream inputStream;
    private final PipedOutputStream outputStream;
    private final int totalFileSize;
    private final InstallFeatureListener listener;
    private final Queue<byte[]> chunkQueue;
    private volatile boolean installErrorOccurred;
    private volatile boolean running;
    private volatile int chunkCount;
    private int currentFileSize;
    private int currentSequenceNumber;
    private final Checksum checksum;
    private final Object lock = new Object();

    public DeployFileController(int installationId, String featureUid, int fileIndex, int fileSize, String filePath, InstallFeatureListener listener) {
        this.totalFileSize = fileSize;
        this.checksum = new Checksum();
        this.chunkQueue = new ArrayDeque<byte[]>();
        this.currentFileSize = 0;
        this.currentSequenceNumber = 0;
        this.chunkCount = 0;
        this.installErrorOccurred = false;
        this.running = false;
        this.listener = listener;
        PipedInputStream pipedInputStream = new PipedInputStream(512);
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        try {
            pipedInputStream.connect(pipedOutputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
        this.chunkConsumerThread = this.createChunkConsumerThread(pipedInputStream, featureUid, fileSize, filePath, listener);
        this.chunkProducerThread = this.createChunkProducerThread(pipedOutputStream, installationId, fileIndex);
        this.inputStream = pipedInputStream;
        this.outputStream = pipedOutputStream;
    }

    public synchronized void start() {
        if (this.running) {
            throw new IllegalStateException();
        }
        this.running = true;
        try {
            this.chunkConsumerThread.start();
            this.chunkProducerThread.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            this.running = false;
            throw new IllegalStateException();
        }
    }

    public synchronized void stop() {
        if (!this.running) {
            throw new IllegalStateException();
        }
        this.running = false;
        try {
            this.outputStream.close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
        Thread currentThread = Thread.currentThread();
        Thread producerThread = this.chunkProducerThread;
        producerThread.interrupt();
        if (producerThread != currentThread) {
            try {
                producerThread.join();
            }
            catch (InterruptedException interruptedException) {
                currentThread.interrupt();
            }
        }
        Thread consumerThread = this.chunkConsumerThread;
        consumerThread.interrupt();
        try {
            consumerThread.join();
        }
        catch (InterruptedException interruptedException) {
            currentThread.interrupt();
        }
        this.chunkQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFileChunk(int sequenceNumber, byte[] chunk) throws InstallFeatureException {
        if (CompanionServer.CHUNK_BATCH_SIZE > 0 && this.chunkCount > CompanionServer.CHUNK_BATCH_SIZE) {
            throw new InstallFeatureException(102);
        }
        Object object = this.lock;
        synchronized (object) {
            if (sequenceNumber != this.currentSequenceNumber) {
                throw new InstallFeatureException(101);
            }
            int newFileSize = this.currentFileSize + chunk.length;
            if (newFileSize > this.totalFileSize) {
                throw new InstallFeatureException(104);
            }
            if (this.installErrorOccurred) {
                throw new InstallFeatureException(103);
            }
            ++this.chunkCount;
            this.currentSequenceNumber = this.currentSequenceNumber + 1 & 0xFF;
            this.currentFileSize += chunk.length;
            this.chunkQueue.offer(chunk);
            this.lock.notifyAll();
        }
    }

    public void onEndOfFile(long checksum) throws InstallFeatureException {
        if (this.currentFileSize != this.totalFileSize) {
            throw new InstallFeatureException(104);
        }
        if (checksum != this.checksum.getValue()) {
            throw new InstallFeatureException(105);
        }
        if (this.installErrorOccurred) {
            throw new InstallFeatureException(103);
        }
    }

    private Thread createChunkConsumerThread(final InputStream inputStream, final String featureUid, final int fileSize, final String filePath, final InstallFeatureListener listener) {
        return new Thread("DeployFileConsumerThread"){

            @Override
            public void run() {
                block3: {
                    try {
                        listener.handleFeatureFile(featureUid, fileSize, filePath, inputStream);
                        if (inputStream.read() != -1) {
                            throw new IOException("File input stream not read fully");
                        }
                    }
                    catch (IOException e) {
                        DeployFileController.this.installErrorOccurred = true;
                        if (!Constants.getBoolean((String)"com.microej.wear.companion.logs.debug")) break block3;
                        Logger.getAnonymousLogger().log(Level.SEVERE, "Error when deploying a file", e);
                    }
                }
            }
        };
    }

    private Thread createChunkProducerThread(final OutputStream outputStream, final int installationId, final int fileIndex) {
        return new Thread("DeployFileProducerThread"){

            @Override
            public void run() {
                DeployFileController controller = DeployFileController.this;
                while (controller.running) {
                    try {
                        byte[] chunk = this.getNextChunk(controller);
                        this.writeChunk(controller, chunk);
                        this.prepareForNextBatch(controller);
                    }
                    catch (InterruptedException interruptedException) {
                        2.currentThread().interrupt();
                        return;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte[] getNextChunk(DeployFileController controller) throws InterruptedException {
                Object object = controller.lock;
                synchronized (object) {
                    Queue queue = controller.chunkQueue;
                    while (queue.isEmpty()) {
                        controller.lock.wait();
                    }
                    byte[] chunk = (byte[])queue.remove();
                    controller.lock.notifyAll();
                    return chunk;
                }
            }

            private void writeChunk(DeployFileController controller, byte[] chunk) {
                try {
                    outputStream.write(chunk);
                    outputStream.flush();
                    controller.checksum.add(chunk);
                }
                catch (IOException iOException) {
                    controller.installErrorOccurred = true;
                }
            }

            private void prepareForNextBatch(DeployFileController controller) {
                int sequenceNumber = controller.currentSequenceNumber;
                if (controller.installErrorOccurred) {
                    controller.listener.onFileChunkWriteFailure(installationId, fileIndex, sequenceNumber, 103);
                } else if (controller.chunkCount == CompanionServer.CHUNK_BATCH_SIZE || controller.currentFileSize == controller.totalFileSize) {
                    controller.listener.onFileChunkWriteSuccess(installationId, fileIndex, sequenceNumber);
                    controller.chunkCount = 0;
                }
            }
        };
    }
}

