/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.companion.server;

import com.microej.wear.companion.protocol.Message;
import com.microej.wear.companion.protocol.ProtocolException;
import com.microej.wear.companion.protocol.messages.EndOfFeatureAckMessage;
import com.microej.wear.companion.protocol.messages.EndOfFileAckMessage;
import com.microej.wear.companion.protocol.messages.FileChunkAckMessage;
import com.microej.wear.companion.protocol.messages.InstallFeatureAckMessage;
import com.microej.wear.companion.protocol.messages.ProtocolVersionMessage;
import com.microej.wear.companion.protocol.messages.StartOfFileAckMessage;
import com.microej.wear.companion.protocol.messages.UnexpectedErrorMessage;
import ej.cbor.CborEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MessageSerializer {
    private static final int BYTE_MASK = 255;

    private MessageSerializer() {
    }

    public static byte[] serialize(Message message) throws ProtocolException {
        int type = message.getType();
        switch (type) {
            case 2: {
                return MessageSerializer.serializeProtocolVersion((ProtocolVersionMessage)message);
            }
            case 3: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                return MessageSerializer.encodeWithCbor(message);
            }
            case 21: {
                return new byte[]{(byte)(type & 0xFF)};
            }
        }
        throw new ProtocolException(1);
    }

    private static byte[] serializeProtocolVersion(ProtocolVersionMessage message) {
        byte[] data = new byte[]{(byte)(message.getType() & 0xFF), (byte)(message.getProtocolVersion() & 0xFF)};
        return data;
    }

    private static byte[] encodeWithCbor(Message message) throws ProtocolException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            int type = message.getType();
            outputStream.write(type & 0xFF);
            CborEncoder encoder = new CborEncoder((OutputStream)outputStream);
            switch (type) {
                case 9: {
                    MessageSerializer.encodeInstallFeatureAck(encoder, (InstallFeatureAckMessage)message);
                    break;
                }
                case 11: {
                    MessageSerializer.encodeStartOfFileAck(encoder, (StartOfFileAckMessage)message);
                    break;
                }
                case 13: {
                    MessageSerializer.encodeFileChunkAck(encoder, (FileChunkAckMessage)message);
                    break;
                }
                case 15: {
                    MessageSerializer.encodeEndOfFileAck(encoder, (EndOfFileAckMessage)message);
                    break;
                }
                case 17: {
                    MessageSerializer.encodeEndOfFeatureAck(encoder, (EndOfFeatureAckMessage)message);
                    break;
                }
                case 3: {
                    MessageSerializer.encodeUnexpectedError(encoder, (UnexpectedErrorMessage)message);
                    break;
                }
                default: {
                    throw new ProtocolException(8);
                }
            }
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new ProtocolException(8, (Exception)e);
        }
    }

    private static void encodeInstallFeatureAck(CborEncoder encoder, InstallFeatureAckMessage message) throws IOException {
        encoder.writeMapStart();
        encoder.writeTextString("installationId");
        encoder.writeInt((long)message.getInstallationId());
        encoder.writeTextString("chunkBatchSize");
        encoder.writeInt((long)message.getChunkBatchSize());
        encoder.writeTextString("errorCode");
        encoder.writeInt((long)message.getErrorCode());
        encoder.writeBreak();
    }

    private static void encodeStartOfFileAck(CborEncoder encoder, StartOfFileAckMessage message) throws IOException {
        encoder.writeMapStart();
        encoder.writeTextString("installationId");
        encoder.writeInt((long)message.getInstallationId());
        encoder.writeTextString("fileIndex");
        encoder.writeInt((long)message.getFileIndex());
        encoder.writeTextString("errorCode");
        encoder.writeInt((long)message.getErrorCode());
        encoder.writeBreak();
    }

    private static void encodeFileChunkAck(CborEncoder encoder, FileChunkAckMessage message) throws IOException {
        encoder.writeMapStart();
        encoder.writeTextString("installationId");
        encoder.writeInt((long)message.getInstallationId());
        encoder.writeTextString("fileIndex");
        encoder.writeInt((long)message.getFileIndex());
        encoder.writeTextString("sequenceNumber");
        encoder.writeInt((long)message.getSequenceNumber());
        encoder.writeTextString("errorCode");
        encoder.writeInt((long)message.getErrorCode());
        encoder.writeBreak();
    }

    private static void encodeEndOfFileAck(CborEncoder encoder, EndOfFileAckMessage message) throws IOException {
        encoder.writeMapStart();
        encoder.writeTextString("installationId");
        encoder.writeInt((long)message.getInstallationId());
        encoder.writeTextString("fileIndex");
        encoder.writeInt((long)message.getFileIndex());
        encoder.writeTextString("errorCode");
        encoder.writeInt((long)message.getErrorCode());
        encoder.writeBreak();
    }

    private static void encodeEndOfFeatureAck(CborEncoder encoder, EndOfFeatureAckMessage message) throws IOException {
        encoder.writeMapStart();
        encoder.writeTextString("installationId");
        encoder.writeInt((long)message.getInstallationId());
        encoder.writeTextString("errorCode");
        encoder.writeInt((long)message.getErrorCode());
        encoder.writeBreak();
    }

    private static void encodeUnexpectedError(CborEncoder encoder, UnexpectedErrorMessage message) throws IOException {
        encoder.writeMapStart();
        encoder.writeTextString("errorCode");
        encoder.writeInt((long)message.getErrorCode());
        encoder.writeBreak();
    }
}

