/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.companion.server;

import com.microej.wear.companion.protocol.Message;
import com.microej.wear.companion.protocol.ProtocolException;
import com.microej.wear.companion.protocol.messages.CurrentTimeMessage;
import com.microej.wear.companion.protocol.messages.EndOfFeatureMessage;
import com.microej.wear.companion.protocol.messages.EndOfFileMessage;
import com.microej.wear.companion.protocol.messages.FileChunkMessage;
import com.microej.wear.companion.protocol.messages.GetProtocolVersionMessage;
import com.microej.wear.companion.protocol.messages.InstallFeatureMessage;
import com.microej.wear.companion.protocol.messages.StartOfFileMessage;
import ej.cbor.CborDecoder;
import ej.cbor.CborType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class MessageDeserializer {
    private static final int FIRST_FIELD = 1;
    private static final int SECOND_FIELD = 2;
    private static final int THIRD_FIELD = 4;
    private static final int FOURTH_FIELD = 8;
    private static final int TWO_FIELDS_MASK = 3;
    private static final int THREE_FIELDS_MASK = 7;
    private static final int FOUR_FIELDS_MASK = 15;
    private static final int BYTE_MASK = 255;
    private static final CborType BREAK = CborType.valueOf((int)255);

    private MessageDeserializer() {
    }

    public static Message deserialize(byte[] data) throws ProtocolException {
        if (data.length == 0) {
            throw new ProtocolException(2);
        }
        int type = data[0] & 0xFF;
        switch (type) {
            case 1: {
                return new GetProtocolVersionMessage();
            }
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 20: {
                return MessageDeserializer.decodeCborMessage(data, type);
            }
            case 12: {
                return MessageDeserializer.deserializeFileChunk(data);
            }
        }
        throw new ProtocolException(1);
    }

    private static Message decodeCborMessage(byte[] data, int type) throws ProtocolException {
        CborDecoder decoder = new CborDecoder((InputStream)new ByteArrayInputStream(data, 1, data.length - 1));
        try {
            if (decoder.readMapLength() != -1L) {
                throw new ProtocolException(6);
            }
            switch (type) {
                case 8: {
                    return MessageDeserializer.decodeInstallFeatureMessage(decoder);
                }
                case 10: {
                    return MessageDeserializer.decodeStartOfFileMessage(decoder);
                }
                case 14: {
                    return MessageDeserializer.decodeEndOfFileMessage(decoder);
                }
                case 16: {
                    return MessageDeserializer.decodeEndOfFeatureMessage(decoder);
                }
                case 20: {
                    return MessageDeserializer.decodeCurrentTimeMessage(decoder);
                }
            }
            throw new ProtocolException(7);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new ProtocolException(7, e);
        }
    }

    private static InstallFeatureMessage decodeInstallFeatureMessage(CborDecoder decoder) throws IOException, ProtocolException {
        int installationId = 0;
        String featureUid = null;
        int fileCount = 0;
        int found = 0;
        while (MessageDeserializer.breakNotFound(decoder)) {
            String key;
            switch (key = decoder.readTextString()) {
                case "installationId": {
                    installationId = (int)decoder.readInt();
                    found |= 1;
                    break;
                }
                case "featureUid": {
                    featureUid = decoder.readTextString();
                    found |= 2;
                    break;
                }
                case "fileCount": {
                    fileCount = (int)decoder.readInt();
                    found |= 4;
                    break;
                }
                default: {
                    throw new ProtocolException(5);
                }
            }
        }
        if (found != 7) {
            throw new ProtocolException(4);
        }
        assert (featureUid != null);
        return new InstallFeatureMessage(installationId, featureUid, fileCount);
    }

    private static StartOfFileMessage decodeStartOfFileMessage(CborDecoder decoder) throws IOException, ProtocolException {
        int installationId = 0;
        int fileIndex = 0;
        int fileSize = 0;
        String filePath = null;
        int found = 0;
        while (MessageDeserializer.breakNotFound(decoder)) {
            String key;
            switch (key = decoder.readTextString()) {
                case "installationId": {
                    installationId = (int)decoder.readInt();
                    found |= 1;
                    break;
                }
                case "fileIndex": {
                    fileIndex = (int)decoder.readInt();
                    found |= 2;
                    break;
                }
                case "fileSize": {
                    fileSize = (int)decoder.readInt();
                    found |= 4;
                    break;
                }
                case "filePath": {
                    filePath = decoder.readTextString();
                    found |= 8;
                    break;
                }
                default: {
                    throw new ProtocolException(5);
                }
            }
        }
        if (found != 15) {
            throw new ProtocolException(4);
        }
        assert (filePath != null);
        return new StartOfFileMessage(installationId, fileIndex, fileSize, filePath);
    }

    private static Message deserializeFileChunk(byte[] data) throws ProtocolException {
        if (data.length < 4) {
            throw new ProtocolException(6);
        }
        return new FileChunkMessage(data[1] & 0xFF, data[2] & 0xFF, data[3] & 0xFF, Arrays.copyOfRange(data, 4, data.length));
    }

    private static EndOfFileMessage decodeEndOfFileMessage(CborDecoder decoder) throws IOException, ProtocolException {
        int installationId = 0;
        int fileIndex = 0;
        long fileChecksum = 0L;
        int found = 0;
        while (MessageDeserializer.breakNotFound(decoder)) {
            String key;
            switch (key = decoder.readTextString()) {
                case "installationId": {
                    installationId = (int)decoder.readInt();
                    found |= 1;
                    break;
                }
                case "fileIndex": {
                    fileIndex = (int)decoder.readInt();
                    found |= 2;
                    break;
                }
                case "fileChecksum": {
                    fileChecksum = decoder.readInt();
                    found |= 4;
                    break;
                }
                default: {
                    throw new ProtocolException(5);
                }
            }
        }
        if (found != 7) {
            throw new ProtocolException(4);
        }
        return new EndOfFileMessage(installationId, fileIndex, fileChecksum);
    }

    private static EndOfFeatureMessage decodeEndOfFeatureMessage(CborDecoder decoder) throws IOException, ProtocolException {
        int installationId = 0;
        boolean found = false;
        while (MessageDeserializer.breakNotFound(decoder)) {
            String key;
            switch (key = decoder.readTextString()) {
                case "installationId": {
                    installationId = (int)decoder.readInt();
                    found = true;
                    break;
                }
                default: {
                    throw new ProtocolException(5);
                }
            }
        }
        if (!found) {
            throw new ProtocolException(4);
        }
        return new EndOfFeatureMessage(installationId);
    }

    private static CurrentTimeMessage decodeCurrentTimeMessage(CborDecoder decoder) throws IOException, ProtocolException {
        long currentTime = 0L;
        String zoneId = null;
        int zoneOffset = 0;
        int found = 0;
        while (MessageDeserializer.breakNotFound(decoder)) {
            String key;
            switch (key = decoder.readTextString()) {
                case "currentTime": {
                    currentTime = decoder.readInt();
                    found |= 1;
                    break;
                }
                case "zoneId": {
                    zoneId = decoder.readTextString();
                    found |= 2;
                    break;
                }
                case "zoneOffset": {
                    zoneOffset = (int)decoder.readInt();
                    found |= 4;
                    break;
                }
                default: {
                    throw new ProtocolException(5);
                }
            }
        }
        if (found != 7) {
            throw new ProtocolException(4);
        }
        assert (zoneId != null);
        return new CurrentTimeMessage(currentTime, zoneId, zoneOffset);
    }

    private static boolean breakNotFound(CborDecoder decoder) throws IOException {
        CborType type = decoder.peekType();
        if (type == null) {
            throw new IOException();
        }
        return !type.equals((Object)BREAK);
    }
}

