/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.companion.server;

import com.microej.wear.companion.protocol.Message;
import com.microej.wear.companion.protocol.ProtocolException;
import com.microej.wear.companion.protocol.messages.CurrentTimeMessage;
import com.microej.wear.companion.protocol.messages.EndOfFeatureAckMessage;
import com.microej.wear.companion.protocol.messages.EndOfFeatureMessage;
import com.microej.wear.companion.protocol.messages.EndOfFileAckMessage;
import com.microej.wear.companion.protocol.messages.EndOfFileMessage;
import com.microej.wear.companion.protocol.messages.FileChunkAckMessage;
import com.microej.wear.companion.protocol.messages.FileChunkMessage;
import com.microej.wear.companion.protocol.messages.InstallFeatureAckMessage;
import com.microej.wear.companion.protocol.messages.InstallFeatureMessage;
import com.microej.wear.companion.protocol.messages.ProtocolVersionMessage;
import com.microej.wear.companion.protocol.messages.RequestCurrentTimeMessage;
import com.microej.wear.companion.protocol.messages.StartOfFileAckMessage;
import com.microej.wear.companion.protocol.messages.StartOfFileMessage;
import com.microej.wear.companion.protocol.messages.UnexpectedErrorMessage;
import com.microej.wear.companion.server.CompanionHandler;
import com.microej.wear.companion.server.MessageDeserializer;
import com.microej.wear.companion.server.MessageSerializer;
import com.microej.wear.companion.server.installfeature.InstallFeatureController;
import com.microej.wear.companion.server.installfeature.InstallFeatureException;
import com.microej.wear.companion.server.installfeature.InstallFeatureListener;
import ej.annotation.Nullable;
import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothConnection;
import ej.bluetooth.BluetoothDescriptor;
import ej.bluetooth.BluetoothService;
import ej.bluetooth.BluetoothUuid;
import ej.bluetooth.listeners.LocalServiceListener;
import ej.bluetooth.listeners.impl.DefaultLocalServiceListener;
import ej.bluetooth.util.AttributeNotFoundException;
import ej.bluetooth.util.DescriptorHelper;
import ej.bluetooth.util.ServiceHelper;
import ej.bon.Constants;
import ej.bon.Timer;
import ej.bon.TimerTask;
import ej.bon.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompanionServer
implements InstallFeatureListener {
    public static final String DEBUG = "com.microej.wear.companion.logs.debug";
    public static final int CHUNK_BATCH_SIZE = Constants.getInt((String)"com.microej.wear.companion.install.feature.batch.size");
    private static final long TIMEOUT_DELAY = 5000L;
    private static final long TIMEOUT_PERIOD = 1000L;
    @Nullable
    private BluetoothConnection connection;
    private final BluetoothService bluetoothService;
    private final BluetoothCharacteristic m2wCharacteristic;
    private final BluetoothCharacteristic w2mCharacteristic;
    private final BluetoothDescriptor w2mCcc;
    private final Timer timer;
    private final CompanionHandler handler;
    @Nullable
    private TimerTask timeoutTask;
    private long lastMessageTime;
    @Nullable
    private InstallFeatureController installFeatureController;

    public CompanionServer(BluetoothService bluetoothService, CompanionHandler handler, Timer timer) {
        this.bluetoothService = bluetoothService;
        this.handler = handler;
        this.timer = timer;
        try {
            this.m2wCharacteristic = ServiceHelper.getCharacteristic((BluetoothService)bluetoothService, (BluetoothUuid)new BluetoothUuid("0FF5CE1F-7091-47A1-AC9F-7E1BD4406345"));
            this.w2mCharacteristic = ServiceHelper.getCharacteristic((BluetoothService)bluetoothService, (BluetoothUuid)new BluetoothUuid("0FF5CE1F-7091-47A1-AC9F-7E1BD4406346"));
            this.w2mCcc = ServiceHelper.getDescriptor((BluetoothCharacteristic)this.w2mCharacteristic, (BluetoothUuid)DescriptorHelper.CCC_UUID);
        }
        catch (AttributeNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void start() {
        this.bluetoothService.setLocalListener((LocalServiceListener)new DefaultLocalServiceListener(){

            public void onWriteRequest(BluetoothConnection connection, BluetoothAttribute attribute, byte[] value) {
                CompanionServer.this.handleWriteRequest(connection, attribute, value);
            }
        });
    }

    public void stop() {
        this.bluetoothService.setLocalListener((LocalServiceListener)new DefaultLocalServiceListener());
    }

    public void requestCurrentTime() {
        this.sendMessage((Message)new RequestCurrentTimeMessage());
    }

    protected void handleMessage(byte[] data) {
        block2: {
            Message message = null;
            try {
                message = MessageDeserializer.deserialize(data);
                this.handleMessage(message);
            }
            catch (ProtocolException e) {
                this.stopCurrentOperation();
                this.respondTo(message, e.getErrorCode());
                if (!Constants.getBoolean((String)DEBUG)) break block2;
                Logger.getAnonymousLogger().log(Level.SEVERE, "Error when handling a message", e);
            }
        }
    }

    protected void sendMessage(Message message) {
        try {
            byte[] data = MessageSerializer.serialize(message);
            BluetoothConnection currentConnection = this.connection;
            if (currentConnection != null && !currentConnection.sendNotification(this.w2mCharacteristic, data, true)) {
                throw new IOException();
            }
        }
        catch (ProtocolException | IOException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Error sending a message", e);
        }
    }

    protected synchronized void stopCurrentOperation() {
        this.stopTimeoutTask();
        InstallFeatureController controller = this.installFeatureController;
        CompanionHandler handler = this.handler;
        if (handler != null) {
            handler.stop();
        }
        if (controller != null) {
            controller.stop();
            this.installFeatureController = null;
        }
    }

    private void handleWriteRequest(BluetoothConnection connection, BluetoothAttribute attribute, byte[] value) {
        this.connection = connection;
        if (attribute == this.m2wCharacteristic) {
            this.handleMessage(value);
        } else if (attribute == this.w2mCcc) {
            connection.sendWriteResponse(attribute, (byte)0);
        } else {
            connection.sendWriteResponse(attribute, (byte)10);
        }
    }

    private void handleMessage(Message message) throws ProtocolException {
        this.lastMessageTime = Util.platformTimeMillis();
        int type = message.getType();
        switch (type) {
            case 1: {
                this.sendMessage((Message)new ProtocolVersionMessage());
                break;
            }
            case 8: {
                this.onInstallFeature((InstallFeatureMessage)message);
                break;
            }
            case 10: {
                this.onStartOfFile((StartOfFileMessage)message);
                break;
            }
            case 12: {
                this.onFileChunk((FileChunkMessage)message);
                break;
            }
            case 14: {
                this.onEndOfFile((EndOfFileMessage)message);
                break;
            }
            case 16: {
                this.onEndOfFeature((EndOfFeatureMessage)message);
                break;
            }
            case 20: {
                this.onCurrentTime((CurrentTimeMessage)message);
                break;
            }
            default: {
                throw new ProtocolException(3);
            }
        }
    }

    private void onInstallFeature(InstallFeatureMessage message) throws ProtocolException {
        InstallFeatureController controller;
        this.stopCurrentOperation();
        try {
            this.handler.beginFeatureInstall(message.getFeatureUid(), message.getFileCount());
        }
        catch (IOException e) {
            throw new ProtocolException(103, (Exception)e);
        }
        catch (InstallFeatureException e) {
            throw new ProtocolException(e.getErrorCode(), (Exception)e);
        }
        this.installFeatureController = controller = new InstallFeatureController(message.getInstallationId(), message.getFeatureUid(), message.getFileCount(), this);
        this.respondTo((Message)message, 0);
        this.startTimeoutTask();
        if (Constants.getBoolean((String)DEBUG)) {
            Logger.getAnonymousLogger().info("Installing new Feature, UID: " + message.getFeatureUid());
        }
    }

    private void onStartOfFile(StartOfFileMessage message) throws ProtocolException {
        InstallFeatureController controller = this.installFeatureController;
        if (controller == null) {
            throw new ProtocolException(3);
        }
        try {
            controller.onStartOfFile(message.getInstallationId(), message.getFileIndex(), message.getFileSize(), message.getFilePath());
        }
        catch (InstallFeatureException e) {
            throw new ProtocolException(e.getErrorCode(), (Exception)e);
        }
        this.respondTo((Message)message, 0);
        if (Constants.getBoolean((String)DEBUG)) {
            Logger.getAnonymousLogger().info("Deploying new file, path: " + message.getFilePath());
        }
    }

    private void onFileChunk(FileChunkMessage message) throws ProtocolException {
        InstallFeatureController controller = this.installFeatureController;
        if (controller == null) {
            throw new ProtocolException(3);
        }
        try {
            controller.onFileChunk(message.getInstallationId(), message.getFileIndex(), message.getSequenceNumber(), message.getFileChunk());
        }
        catch (InstallFeatureException e) {
            throw new ProtocolException(e.getErrorCode(), (Exception)e);
        }
    }

    private void onEndOfFile(EndOfFileMessage message) throws ProtocolException {
        InstallFeatureController controller = this.installFeatureController;
        if (controller == null) {
            throw new ProtocolException(3);
        }
        try {
            controller.onEndOfFile(message.getInstallationId(), message.getFileIndex(), message.getFileChecksum());
        }
        catch (InstallFeatureException e) {
            throw new ProtocolException(e.getErrorCode(), (Exception)e);
        }
        this.respondTo((Message)message, 0);
        if (Constants.getBoolean((String)DEBUG)) {
            Logger.getAnonymousLogger().info("File successfully deployed");
        }
    }

    private void onEndOfFeature(EndOfFeatureMessage message) throws ProtocolException {
        InstallFeatureController controller = this.installFeatureController;
        if (controller == null) {
            throw new ProtocolException(3);
        }
        try {
            controller.onEndOfFeature(message.getInstallationId());
        }
        catch (InstallFeatureException e) {
            throw new ProtocolException(e.getErrorCode(), (Exception)e);
        }
        this.respondTo((Message)message, 0);
        this.stopCurrentOperation();
        if (Constants.getBoolean((String)DEBUG)) {
            Logger.getAnonymousLogger().info("Feature successfully installed");
        }
    }

    private void onCurrentTime(CurrentTimeMessage message) {
        long currentTime = message.getCurrentTime();
        String zoneId = message.getZoneId();
        int zoneOffset = message.getZoneOffset();
        if (Constants.getBoolean((String)DEBUG)) {
            Logger.getAnonymousLogger().log(Level.INFO, "Received the current time: " + currentTime + ", zone ID: " + zoneId + ", zoneOffset: " + zoneOffset);
        }
        this.handler.setTimeConfiguration(currentTime, zoneId, zoneOffset);
    }

    private void respondTo(@Nullable Message message, int errorCode) {
        Message response = CompanionServer.createResponseTo(message, errorCode);
        this.sendMessage(response);
    }

    private void startTimeoutTask() {
        this.stopTimeoutTask();
        TimerTask task = new TimerTask(){

            public void run() {
                long elapsed = Util.platformTimeMillis() - CompanionServer.this.lastMessageTime;
                if (elapsed > 5000L) {
                    CompanionServer.this.stopCurrentOperation();
                    CompanionServer.this.sendMessage((Message)new UnexpectedErrorMessage(9));
                }
            }
        };
        this.timer.schedule(task, 5000L, 1000L);
        this.timeoutTask = task;
    }

    private void stopTimeoutTask() {
        TimerTask task = this.timeoutTask;
        if (task != null) {
            task.cancel();
            this.timeoutTask = null;
        }
    }

    private static Message createResponseTo(@Nullable Message message, int errorCode) {
        if (message == null) {
            return new UnexpectedErrorMessage(errorCode);
        }
        int type = message.getType();
        switch (type) {
            case 8: {
                return new InstallFeatureAckMessage(((InstallFeatureMessage)message).getInstallationId(), CHUNK_BATCH_SIZE, errorCode);
            }
            case 10: {
                StartOfFileMessage startOfFileMessage = (StartOfFileMessage)message;
                return new StartOfFileAckMessage(startOfFileMessage.getInstallationId(), startOfFileMessage.getFileIndex(), errorCode);
            }
            case 12: {
                FileChunkMessage chunkMessage = (FileChunkMessage)message;
                return new FileChunkAckMessage(chunkMessage.getInstallationId(), chunkMessage.getFileIndex(), chunkMessage.getSequenceNumber(), errorCode);
            }
            case 14: {
                EndOfFileMessage endOfFileMessage = (EndOfFileMessage)message;
                return new EndOfFileAckMessage(endOfFileMessage.getInstallationId(), endOfFileMessage.getFileIndex(), errorCode);
            }
            case 16: {
                return new EndOfFeatureAckMessage(((EndOfFeatureMessage)message).getInstallationId(), errorCode);
            }
        }
        return new UnexpectedErrorMessage(errorCode);
    }

    @Override
    public void handleFeatureFile(String featureUid, int fileSize, String filePath, InputStream inputStream) throws IOException {
        this.handler.handleFeatureFile(featureUid, fileSize, filePath, inputStream);
    }

    @Override
    public void completeFeatureInstall(String featureUid) throws IOException {
        this.handler.completeFeatureInstall(featureUid);
    }

    @Override
    public void onFileChunkWriteSuccess(int installationId, int fileIndex, int sequenceNumber) {
        this.sendMessage((Message)new FileChunkAckMessage(installationId, fileIndex, sequenceNumber, 0));
    }

    @Override
    public void onFileChunkWriteFailure(int installationId, int fileIndex, int sequenceNumber, int errorCode) {
        this.stopCurrentOperation();
        this.sendMessage((Message)new FileChunkAckMessage(installationId, fileIndex, sequenceNumber, errorCode));
    }
}

