/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Select;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.bcel.verifier.structurals.Subroutine;

public class Subroutines {
    private static final Integer WHITE = 0;
    private static final Integer GRAY = 1;
    private static final Integer BLACK = 2;
    private final Map<InstructionHandle, Subroutine> subroutines = new HashMap<InstructionHandle, Subroutine>();
    public final Subroutine TOPLEVEL;

    public Subroutines(MethodGen mg) {
        Instruction inst;
        InstructionHandle element;
        InstructionHandle[] all = mg.getInstructionList().getInstructionHandles();
        CodeExceptionGen[] handlers = mg.getExceptionHandlers();
        this.TOPLEVEL = new SubroutineImpl();
        HashSet<InstructionHandle> sub_leaders = new HashSet<InstructionHandle>();
        InstructionHandle[] instructionHandleArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            element = instructionHandleArray[n2];
            inst = element.getInstruction();
            if (inst instanceof JsrInstruction) {
                sub_leaders.add(((JsrInstruction)inst).getTarget());
            }
            ++n2;
        }
        for (InstructionHandle astore : sub_leaders) {
            SubroutineImpl sr = new SubroutineImpl();
            sr.setLocalVariable(((ASTORE)astore.getInstruction()).getIndex());
            this.subroutines.put(astore, sr);
        }
        this.subroutines.put(all[0], this.TOPLEVEL);
        sub_leaders.add(all[0]);
        instructionHandleArray = all;
        int sr = all.length;
        int n3 = 0;
        while (n3 < sr) {
            element = instructionHandleArray[n3];
            inst = element.getInstruction();
            if (inst instanceof JsrInstruction) {
                InstructionHandle leader = ((JsrInstruction)inst).getTarget();
                ((SubroutineImpl)this.getSubroutine(leader)).addEnteringJsrInstruction(element);
            }
            ++n3;
        }
        HashSet<InstructionHandle> instructions_assigned = new HashSet<InstructionHandle>();
        HashMap<InstructionHandle, Integer> colors = new HashMap<InstructionHandle, Integer>();
        ArrayList<InstructionHandle> Q = new ArrayList<InstructionHandle>();
        for (InstructionHandle actual : sub_leaders) {
            Serializable element2;
            Serializable[] serializableArray = all;
            int n4 = all.length;
            int n5 = 0;
            while (n5 < n4) {
                element2 = serializableArray[n5];
                colors.put((InstructionHandle)element2, WHITE);
                ++n5;
            }
            colors.put(actual, GRAY);
            Q.clear();
            Q.add(actual);
            if (actual == all[0]) {
                serializableArray = handlers;
                n4 = handlers.length;
                n5 = 0;
                while (n5 < n4) {
                    Serializable handler = serializableArray[n5];
                    colors.put(((CodeExceptionGen)handler).getHandlerPC(), GRAY);
                    Q.add(((CodeExceptionGen)handler).getHandlerPC());
                    ++n5;
                }
            }
            while (Q.size() != 0) {
                InstructionHandle[] successors;
                InstructionHandle u = (InstructionHandle)Q.remove(0);
                InstructionHandle[] instructionHandleArray2 = successors = Subroutines.getSuccessors(u);
                int n6 = successors.length;
                int n7 = 0;
                while (n7 < n6) {
                    InstructionHandle successor = instructionHandleArray2[n7];
                    if (colors.get(successor) == WHITE) {
                        colors.put(successor, GRAY);
                        Q.add(successor);
                    }
                    ++n7;
                }
                colors.put(u, BLACK);
            }
            serializableArray = all;
            int successor = all.length;
            n5 = 0;
            while (n5 < successor) {
                element2 = serializableArray[n5];
                if (colors.get(element2) == BLACK) {
                    ((SubroutineImpl)(actual == all[0] ? this.getTopLevel() : this.getSubroutine(actual))).addInstruction((InstructionHandle)element2);
                    if (instructions_assigned.contains(element2)) {
                        throw new StructuralCodeConstraintException("Instruction '" + element2 + "' is part of more than one subroutine (or of the top level and a subroutine).");
                    }
                    instructions_assigned.add((InstructionHandle)element2);
                }
                ++n5;
            }
            if (actual == all[0]) continue;
            ((SubroutineImpl)this.getSubroutine(actual)).setLeavingRET();
        }
        CodeExceptionGen[] codeExceptionGenArray = handlers;
        int n8 = handlers.length;
        int n9 = 0;
        while (n9 < n8) {
            CodeExceptionGen handler = codeExceptionGenArray[n9];
            InstructionHandle _protected = handler.getStartPC();
            while (_protected != handler.getEndPC().getNext()) {
                for (Subroutine sub : this.subroutines.values()) {
                    if (sub == this.subroutines.get(all[0]) || !sub.contains(_protected)) continue;
                    throw new StructuralCodeConstraintException("Subroutine instruction '" + _protected + "' is protected by an exception handler, '" + handler + "'. This is forbidden by the JustIce verifier due to its clear definition of subroutines.");
                }
                _protected = _protected.getNext();
            }
            ++n9;
        }
        this.noRecursiveCalls(this.getTopLevel(), new HashSet<Integer>());
    }

    private void noRecursiveCalls(Subroutine sub, Set<Integer> set) {
        Subroutine[] subs;
        Subroutine[] subroutineArray = subs = sub.subSubs();
        int n = subs.length;
        int n2 = 0;
        while (n2 < n) {
            Subroutine sub2 = subroutineArray[n2];
            int index = ((RET)sub2.getLeavingRET().getInstruction()).getIndex();
            if (!set.add(index)) {
                SubroutineImpl si = (SubroutineImpl)sub2;
                throw new StructuralCodeConstraintException("Subroutine with local variable '" + si.localVariable + "', JSRs '" + si.theJSRs + "', RET '" + si.theRET + "' is called by a subroutine which uses the same local variable index as itself; maybe even a recursive call? JustIce's clean definition of a subroutine forbids both.");
            }
            this.noRecursiveCalls(sub2, set);
            set.remove(index);
            ++n2;
        }
    }

    public Subroutine getSubroutine(InstructionHandle leader) {
        Subroutine ret = this.subroutines.get(leader);
        if (ret == null) {
            throw new AssertionViolatedException("Subroutine requested for an InstructionHandle that is not a leader of a subroutine.");
        }
        if (ret == this.TOPLEVEL) {
            throw new AssertionViolatedException("TOPLEVEL special subroutine requested; use getTopLevel().");
        }
        return ret;
    }

    public Subroutine subroutineOf(InstructionHandle any) {
        for (Subroutine s : this.subroutines.values()) {
            if (!s.contains(any)) continue;
            return s;
        }
        return null;
    }

    public Subroutine getTopLevel() {
        return this.TOPLEVEL;
    }

    private static InstructionHandle[] getSuccessors(InstructionHandle instruction) {
        InstructionHandle[] empty = new InstructionHandle[]{};
        InstructionHandle[] single = new InstructionHandle[1];
        Instruction inst = instruction.getInstruction();
        if (inst instanceof RET) {
            return empty;
        }
        if (inst instanceof ReturnInstruction) {
            return empty;
        }
        if (inst instanceof ATHROW) {
            return empty;
        }
        if (inst instanceof JsrInstruction) {
            single[0] = instruction.getNext();
            return single;
        }
        if (inst instanceof GotoInstruction) {
            single[0] = ((GotoInstruction)inst).getTarget();
            return single;
        }
        if (inst instanceof BranchInstruction) {
            if (inst instanceof Select) {
                InstructionHandle[] matchTargets = ((Select)inst).getTargets();
                InstructionHandle[] ret = new InstructionHandle[matchTargets.length + 1];
                ret[0] = ((Select)inst).getTarget();
                System.arraycopy(matchTargets, 0, ret, 1, matchTargets.length);
                return ret;
            }
            InstructionHandle[] pair = new InstructionHandle[]{instruction.getNext(), ((BranchInstruction)inst).getTarget()};
            return pair;
        }
        single[0] = instruction.getNext();
        return single;
    }

    public String toString() {
        return "---\n" + this.subroutines + "\n---\n";
    }

    private class SubroutineImpl
    implements Subroutine {
        private static final int UNSET = -1;
        private int localVariable = -1;
        private final Set<InstructionHandle> instructions = new HashSet<InstructionHandle>();
        private final Set<InstructionHandle> theJSRs = new HashSet<InstructionHandle>();
        private InstructionHandle theRET;

        @Override
        public boolean contains(InstructionHandle inst) {
            return this.instructions.contains(inst);
        }

        public String toString() {
            int element;
            int[] alv;
            String ret = "Subroutine: Local variable is '" + this.localVariable + "', JSRs are '" + this.theJSRs + "', RET is '" + this.theRET + "', Instructions: '" + this.instructions + "'.";
            ret = String.valueOf(ret) + " Accessed local variable slots: '";
            int[] nArray = alv = this.getAccessedLocalsIndices();
            int n = alv.length;
            int n2 = 0;
            while (n2 < n) {
                element = nArray[n2];
                ret = String.valueOf(ret) + element + " ";
                ++n2;
            }
            ret = String.valueOf(ret) + "'.";
            ret = String.valueOf(ret) + " Recursively (via subsub...routines) accessed local variable slots: '";
            nArray = alv = this.getRecursivelyAccessedLocalsIndices();
            n = alv.length;
            n2 = 0;
            while (n2 < n) {
                element = nArray[n2];
                ret = String.valueOf(ret) + element + " ";
                ++n2;
            }
            ret = String.valueOf(ret) + "'.";
            return ret;
        }

        void setLeavingRET() {
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("setLeavingRET() called for top-level 'subroutine' or forgot to set local variable first.");
            }
            InstructionHandle ret = null;
            for (InstructionHandle actual : this.instructions) {
                if (!(actual.getInstruction() instanceof RET)) continue;
                if (ret != null) {
                    throw new StructuralCodeConstraintException("Subroutine with more then one RET detected: '" + ret + "' and '" + actual + "'.");
                }
                ret = actual;
            }
            if (ret == null) {
                throw new StructuralCodeConstraintException("Subroutine without a RET detected.");
            }
            if (((RET)ret.getInstruction()).getIndex() != this.localVariable) {
                throw new StructuralCodeConstraintException("Subroutine uses '" + ret + "' which does not match the correct local variable '" + this.localVariable + "'.");
            }
            this.theRET = ret;
        }

        @Override
        public InstructionHandle[] getEnteringJsrInstructions() {
            if (this == Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            InstructionHandle[] jsrs = new InstructionHandle[this.theJSRs.size()];
            return this.theJSRs.toArray(jsrs);
        }

        public void addEnteringJsrInstruction(InstructionHandle jsrInst) {
            if (jsrInst == null || !(jsrInst.getInstruction() instanceof JsrInstruction)) {
                throw new AssertionViolatedException("Expecting JsrInstruction InstructionHandle.");
            }
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("Set the localVariable first!");
            }
            if (this.localVariable != ((ASTORE)((JsrInstruction)jsrInst.getInstruction()).getTarget().getInstruction()).getIndex()) {
                throw new AssertionViolatedException("Setting a wrong JsrInstruction.");
            }
            this.theJSRs.add(jsrInst);
        }

        @Override
        public InstructionHandle getLeavingRET() {
            if (this == Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            return this.theRET;
        }

        @Override
        public InstructionHandle[] getInstructions() {
            InstructionHandle[] ret = new InstructionHandle[this.instructions.size()];
            return this.instructions.toArray(ret);
        }

        void addInstruction(InstructionHandle ih) {
            if (this.theRET != null) {
                throw new AssertionViolatedException("All instructions must have been added before invoking setLeavingRET().");
            }
            this.instructions.add(ih);
        }

        @Override
        public int[] getRecursivelyAccessedLocalsIndices() {
            HashSet<Integer> s = new HashSet<Integer>();
            int[] lvs = this.getAccessedLocalsIndices();
            Object object = lvs;
            int n = lvs.length;
            int n2 = 0;
            while (n2 < n) {
                int lv = object[n2];
                s.add(lv);
                ++n2;
            }
            this._getRecursivelyAccessedLocalsIndicesHelper(s, this.subSubs());
            int[] ret = new int[s.size()];
            int j = -1;
            object = s.iterator();
            while (object.hasNext()) {
                Integer index = (Integer)object.next();
                ret[++j] = index;
            }
            return ret;
        }

        private void _getRecursivelyAccessedLocalsIndicesHelper(Set<Integer> s, Subroutine[] subs) {
            Subroutine[] subroutineArray = subs;
            int n = subs.length;
            int n2 = 0;
            while (n2 < n) {
                int[] lvs;
                Subroutine sub = subroutineArray[n2];
                int[] nArray = lvs = sub.getAccessedLocalsIndices();
                int n3 = lvs.length;
                int n4 = 0;
                while (n4 < n3) {
                    int lv = nArray[n4];
                    s.add(lv);
                    ++n4;
                }
                if (sub.subSubs().length != 0) {
                    this._getRecursivelyAccessedLocalsIndicesHelper(s, sub.subSubs());
                }
                ++n2;
            }
        }

        @Override
        public int[] getAccessedLocalsIndices() {
            HashSet<Integer> acc = new HashSet<Integer>();
            if (this.theRET == null && this != Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("This subroutine object must be built up completely before calculating accessed locals.");
            }
            for (InstructionHandle ih : this.instructions) {
                if (!(ih.getInstruction() instanceof LocalVariableInstruction) && !(ih.getInstruction() instanceof RET)) continue;
                int idx = ((IndexedInstruction)((Object)ih.getInstruction())).getIndex();
                acc.add(idx);
                try {
                    int s;
                    if (!(ih.getInstruction() instanceof LocalVariableInstruction) || (s = ((LocalVariableInstruction)ih.getInstruction()).getType(null).getSize()) != 2) continue;
                    acc.add(idx + 1);
                }
                catch (RuntimeException re) {
                    throw new AssertionViolatedException("Oops. BCEL did not like NULL as a ConstantPoolGen object.", re);
                }
            }
            int[] ret = new int[acc.size()];
            int j = -1;
            for (Integer accessedLocal : acc) {
                ret[++j] = accessedLocal;
            }
            return ret;
        }

        @Override
        public Subroutine[] subSubs() {
            HashSet<Subroutine> h = new HashSet<Subroutine>();
            for (InstructionHandle ih : this.instructions) {
                Instruction inst = ih.getInstruction();
                if (!(inst instanceof JsrInstruction)) continue;
                InstructionHandle targ = ((JsrInstruction)inst).getTarget();
                h.add(Subroutines.this.getSubroutine(targ));
            }
            Subroutine[] ret = new Subroutine[h.size()];
            return h.toArray(ret);
        }

        void setLocalVariable(int i) {
            if (this.localVariable != -1) {
                throw new AssertionViolatedException("localVariable set twice.");
            }
            this.localVariable = i;
        }
    }
}

