/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.verifier.structurals.InstructionContext;
import org.apache.bcel.verifier.structurals.Range;

class InstructionBlock
extends Range
implements Cloneable {
    private List<InstructionContext> instructions = new ArrayList<InstructionContext>();
    private boolean freezed;

    public InstructionBlock(int firstInstructionIndex) {
        super(firstInstructionIndex);
    }

    public InstructionContext get(int i) {
        return this.instructions.get(i - this.firstInstructionIndex);
    }

    public void add(InstructionContext ic) {
        if (this.freezed || this.instructions.size() != this.size) {
            throw new AssertionError((Object)"Concurrent modification of execution chain.");
        }
        this.instructions.add(ic);
        ++this.size;
    }

    public void freeze() {
        this.freezed = true;
    }

    public InstructionBlock clone() {
        try {
            return (InstructionBlock)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

