/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.bcel.verifier.structurals.InstructionBlock;
import org.apache.bcel.verifier.structurals.InstructionContext;
import org.apache.bcel.verifier.structurals.Range;

public class ExecutionChain
implements Cloneable {
    private List<InstructionBlock> blocks = new ArrayList<InstructionBlock>();
    private InstructionBlock lastAccessedInstructionBlock = new InstructionBlock(0);
    private boolean freezed;

    public ExecutionChain() {
        this.blocks.add(this.lastAccessedInstructionBlock);
    }

    public InstructionContext get(int i) {
        if (!this.lastAccessedInstructionBlock.isInRange(i)) {
            int index = Collections.binarySearch(this.blocks, new Range(i));
            this.lastAccessedInstructionBlock = this.blocks.get(index);
        }
        return this.lastAccessedInstructionBlock.get(i);
    }

    public int size() {
        int size = 0;
        for (InstructionBlock block : this.blocks) {
            size += block.size();
        }
        return size;
    }

    public void add(InstructionContext ic) {
        if (this.freezed) {
            throw new AssertionError((Object)"Invalid modification of execution chain.");
        }
        this.blocks.get(this.blocks.size() - 1).add(ic);
    }

    private void startNewBlock() {
        InstructionBlock previousBlock = this.blocks.get(this.blocks.size() - 1);
        previousBlock.freeze();
        this.blocks.add(new InstructionBlock(previousBlock.getFirstInstructionIndex() + previousBlock.size()));
    }

    public ExecutionChain clone() {
        try {
            ExecutionChain clone = (ExecutionChain)super.clone();
            List<InstructionBlock> cloneBlocks = clone.blocks;
            cloneBlocks = new ArrayList<InstructionBlock>();
            int nbBlocksToKeep = this.blocks.size() - 1;
            int i = 0;
            while (i < nbBlocksToKeep) {
                cloneBlocks.add(this.blocks.get(i));
                ++i;
            }
            cloneBlocks.add(this.blocks.get(nbBlocksToKeep).clone());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public ExecutionChain fork() {
        ExecutionChain fork = this.clone();
        fork.startNewBlock();
        return fork;
    }

    public ExecutionChain readOnlyClone() {
        try {
            ExecutionChain ec = (ExecutionChain)super.clone();
            ec.freezed = true;
            return ec;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

