/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Select;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.bcel.verifier.structurals.ExceptionHandler;
import org.apache.bcel.verifier.structurals.ExceptionHandlers;
import org.apache.bcel.verifier.structurals.ExecutionChain;
import org.apache.bcel.verifier.structurals.ExecutionVisitor;
import org.apache.bcel.verifier.structurals.Frame;
import org.apache.bcel.verifier.structurals.InstConstraintVisitor;
import org.apache.bcel.verifier.structurals.InstructionContext;
import org.apache.bcel.verifier.structurals.LocalVariables;
import org.apache.bcel.verifier.structurals.OperandStack;
import org.apache.bcel.verifier.structurals.Subroutine;
import org.apache.bcel.verifier.structurals.Subroutines;

public class ControlFlowGraph {
    private final MethodGen method_gen;
    private final boolean ignoreMissingClasses;
    private final Subroutines subroutines;
    private final ExceptionHandlers exceptionhandlers;
    private final Map<InstructionHandle, InstructionContext> instructionContexts = new HashMap<InstructionHandle, InstructionContext>();

    public ControlFlowGraph(MethodGen method_gen, boolean ignoreMissingClasses) {
        InstructionHandle[] instructionhandles;
        this.subroutines = new Subroutines(method_gen);
        this.exceptionhandlers = new ExceptionHandlers(method_gen);
        this.ignoreMissingClasses = ignoreMissingClasses;
        InstructionHandle[] instructionHandleArray = instructionhandles = method_gen.getInstructionList().getInstructionHandles();
        int n = instructionhandles.length;
        int n2 = 0;
        while (n2 < n) {
            InstructionHandle instructionhandle = instructionHandleArray[n2];
            this.instructionContexts.put(instructionhandle, new InstructionContextImpl(instructionhandle, this.ignoreMissingClasses));
            ++n2;
        }
        this.method_gen = method_gen;
    }

    public InstructionContext contextOf(InstructionHandle inst) {
        InstructionContext ic = this.instructionContexts.get(inst);
        if (ic == null) {
            throw new AssertionViolatedException("InstructionContext requested for an InstructionHandle that's not known!");
        }
        return ic;
    }

    public InstructionContext[] contextsOf(InstructionHandle[] insts) {
        InstructionContext[] ret = new InstructionContext[insts.length];
        int i = 0;
        while (i < insts.length) {
            ret[i] = this.contextOf(insts[i]);
            ++i;
        }
        return ret;
    }

    public InstructionContext[] getInstructionContexts() {
        InstructionContext[] ret = new InstructionContext[this.instructionContexts.values().size()];
        return this.instructionContexts.values().toArray(ret);
    }

    public boolean isDead(InstructionHandle i) {
        return this.subroutines.subroutineOf(i) == null;
    }

    private class InstructionContextImpl
    implements InstructionContext {
        private int TAG;
        private final InstructionHandle instruction;
        private final Map<InstructionContext, Frame> inFrames;
        private final Map<InstructionContext, Frame> outFrames;
        private ExecutionChain executionPredecessors = null;
        private final boolean ignoreMissingClasses;

        public InstructionContextImpl(InstructionHandle inst, boolean ignoreMissingClasses) {
            if (inst == null) {
                throw new AssertionViolatedException("Cannot instantiate InstructionContextImpl from NULL.");
            }
            this.instruction = inst;
            this.inFrames = new HashMap<InstructionContext, Frame>();
            this.outFrames = new HashMap<InstructionContext, Frame>();
            this.ignoreMissingClasses = ignoreMissingClasses;
        }

        @Override
        public int getTag() {
            return this.TAG;
        }

        @Override
        public void setTag(int tag) {
            this.TAG = tag;
        }

        @Override
        public ExceptionHandler[] getExceptionHandlers() {
            return ControlFlowGraph.this.exceptionhandlers.getExceptionHandlers(this.getInstruction());
        }

        @Override
        public Frame getOutFrame(ExecutionChain execChain) {
            this.executionPredecessors = execChain;
            InstructionContextImpl jsr = this.lastExecutionJSR();
            Frame org = this.outFrames.get(jsr);
            if (org == null) {
                MethodGen m = ControlFlowGraph.this.method_gen;
                org = new Frame(m.getMaxLocals(), m.getMaxStack(), this.ignoreMissingClasses);
            }
            return org.getClone();
        }

        @Override
        public Frame getInFrame() {
            InstructionContextImpl jsr = this.lastExecutionJSR();
            Frame org = this.inFrames.get(jsr);
            if (org == null) {
                MethodGen m = ControlFlowGraph.this.method_gen;
                org = new Frame(m.getMaxLocals(), m.getMaxStack(), this.ignoreMissingClasses);
            }
            return org.getClone();
        }

        @Override
        public boolean execute(Frame inFrame, ExecutionChain execPreds, InstConstraintVisitor icv, ExecutionVisitor ev) {
            this.executionPredecessors = execPreds;
            if (this.lastExecutionJSR() == null && ControlFlowGraph.this.subroutines.subroutineOf(this.getInstruction()) != ControlFlowGraph.this.subroutines.getTopLevel()) {
                throw new AssertionViolatedException("Huh?! Am I '" + this + "' part of a subroutine or not?");
            }
            if (this.lastExecutionJSR() != null && ControlFlowGraph.this.subroutines.subroutineOf(this.getInstruction()) == ControlFlowGraph.this.subroutines.getTopLevel()) {
                throw new AssertionViolatedException("Huh?! Am I '" + this + "' part of a subroutine or not?");
            }
            Frame inF = this.inFrames.get(this.lastExecutionJSR());
            if (inF == null) {
                this.inFrames.put(this.lastExecutionJSR(), inFrame);
                inF = inFrame;
            } else {
                if (inF.equals(inFrame)) {
                    return false;
                }
                if (!this.mergeInFrames(inFrame)) {
                    return false;
                }
            }
            Frame workingFrame = inF.getClone();
            try {
                icv.setFrame(workingFrame);
                this.getInstruction().accept(icv);
            }
            catch (StructuralCodeConstraintException ce) {
                ce.extendMessage("", "\nInstructionHandle: " + this.getInstruction() + "\n");
                ce.extendMessage("", "\nExecution Frame:\n" + workingFrame);
                this.extendMessageWithFlow(ce);
                throw ce;
            }
            ev.setFrame(workingFrame);
            this.getInstruction().accept(ev);
            this.outFrames.put(this.lastExecutionJSR(), workingFrame);
            return true;
        }

        public String toString() {
            String ret = String.valueOf(this.getInstruction().toString(false)) + "\t[InstructionContext]";
            return ret;
        }

        private boolean mergeInFrames(Frame inFrame) {
            Frame inF = this.inFrames.get(this.lastExecutionJSR());
            OperandStack oldstack = inF.getStack().getClone();
            LocalVariables oldlocals = inF.getLocals().getClone();
            try {
                inF.getStack().merge(inFrame.getStack());
                inF.getLocals().merge(inFrame.getLocals());
            }
            catch (StructuralCodeConstraintException sce) {
                this.extendMessageWithFlow(sce);
                throw sce;
            }
            return !oldstack.equals(inF.getStack()) || !oldlocals.equals(inF.getLocals());
        }

        private String getExecutionChain() {
            String s = this.toString();
            int i = this.executionPredecessors.size() - 1;
            while (i >= 0) {
                s = this.executionPredecessors.get(i) + "\n" + s;
                --i;
            }
            return s;
        }

        private void extendMessageWithFlow(StructuralCodeConstraintException e) {
            String s = "Execution flow:\n";
            e.extendMessage("", String.valueOf(s) + this.getExecutionChain());
        }

        @Override
        public InstructionHandle getInstruction() {
            return this.instruction;
        }

        private InstructionContextImpl lastExecutionJSR() {
            int size = this.executionPredecessors.size();
            int retcount = 0;
            int i = size - 1;
            while (i >= 0) {
                InstructionContextImpl current = (InstructionContextImpl)this.executionPredecessors.get(i);
                Instruction currentlast = current.getInstruction().getInstruction();
                if (currentlast instanceof RET) {
                    ++retcount;
                }
                if (currentlast instanceof JsrInstruction && --retcount == -1) {
                    return current;
                }
                --i;
            }
            return null;
        }

        @Override
        public InstructionContext[] getSuccessors() {
            return ControlFlowGraph.this.contextsOf(this._getSuccessors());
        }

        private InstructionHandle[] _getSuccessors() {
            InstructionHandle[] empty = new InstructionHandle[]{};
            InstructionHandle[] single = new InstructionHandle[1];
            Instruction inst = this.getInstruction().getInstruction();
            if (inst instanceof RET) {
                Subroutine s = ControlFlowGraph.this.subroutines.subroutineOf(this.getInstruction());
                if (s == null) {
                    throw new AssertionViolatedException("Asking for successors of a RET in dead code?!");
                }
                InstructionHandle[] jsrs = s.getEnteringJsrInstructions();
                InstructionHandle[] ret = new InstructionHandle[jsrs.length];
                int i = 0;
                while (i < jsrs.length) {
                    ret[i] = jsrs[i].getNext();
                    ++i;
                }
                return ret;
            }
            if (inst instanceof ReturnInstruction) {
                return empty;
            }
            if (inst instanceof ATHROW) {
                return empty;
            }
            if (inst instanceof JsrInstruction) {
                single[0] = ((JsrInstruction)inst).getTarget();
                return single;
            }
            if (inst instanceof GotoInstruction) {
                single[0] = ((GotoInstruction)inst).getTarget();
                return single;
            }
            if (inst instanceof BranchInstruction) {
                if (inst instanceof Select) {
                    InstructionHandle[] matchTargets = ((Select)inst).getTargets();
                    InstructionHandle[] ret = new InstructionHandle[matchTargets.length + 1];
                    ret[0] = ((Select)inst).getTarget();
                    System.arraycopy(matchTargets, 0, ret, 1, matchTargets.length);
                    return ret;
                }
                InstructionHandle[] pair = new InstructionHandle[]{this.getInstruction().getNext(), ((BranchInstruction)inst).getTarget()};
                return pair;
            }
            single[0] = this.getInstruction().getNext();
            return single;
        }
    }
}

