/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.statics;

import java.io.IOException;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.verifier.PassVerifier;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.exc.LoadingException;
import org.apache.bcel.verifier.exc.Utility;

public final class Pass1Verifier
extends PassVerifier {
    private JavaClass jc;

    public Pass1Verifier(Verifier owner) {
        super(owner);
    }

    private JavaClass getJavaClass() {
        if (this.jc == null) {
            try {
                String className = this.myOwner.getClassName();
                if (className == null) {
                    byte[] bytecode = this.myOwner.getBytecode();
                    this.jc = new ClassParser(bytecode).parse();
                    this.myOwner.setClassName(this.jc.getClassName());
                    Repository.storeClass(this.jc);
                } else {
                    this.jc = Repository.lookupClass(this.myOwner.getClassName());
                }
            }
            catch (IOException | ClassNotFoundException exception) {}
        }
        return this.jc;
    }

    @Override
    public VerificationResult do_verify() {
        JavaClass jc;
        try {
            String className;
            jc = this.getJavaClass();
            if (jc != null && (className = this.myOwner.getClassName()) != null && !this.myOwner.getClassName().equals(jc.getClassName())) {
                throw new LoadingException("Wrong name: the internal name of the .class file '" + jc.getClassName() + "' does not match the file's name '" + this.myOwner.getClassName() + "'.");
            }
        }
        catch (LoadingException e) {
            return new VerificationResult(2, e.getMessage());
        }
        catch (ClassFormatException e) {
            return new VerificationResult(2, e.getMessage());
        }
        catch (RuntimeException e) {
            return new VerificationResult(2, "Parsing via BCEL did not succeed. " + e.getClass().getName() + " occured:\n" + Utility.getStackTrace(e));
        }
        if (jc != null || this.ignoreMissingClasses()) {
            return VerificationResult.VR_OK;
        }
        return new VerificationResult(2, "Class " + this.myOwner.getClassName() + " not found.");
    }

    @Override
    public String[] getMessages() {
        return super.getMessages();
    }
}

