/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.statics;

import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.LocalVariableInfoInconsistentException;
import org.apache.bcel.verifier.statics.DOUBLE_Upper;
import org.apache.bcel.verifier.statics.LONG_Upper;
import org.apache.bcel.verifier.statics.LocalVariableInfo;

public class LocalVariablesInfo {
    private final LocalVariableInfo[] localVariableInfos;

    LocalVariablesInfo(int max_locals) {
        this.localVariableInfos = new LocalVariableInfo[max_locals];
        int i = 0;
        while (i < max_locals) {
            this.localVariableInfos[i] = new LocalVariableInfo();
            ++i;
        }
    }

    public LocalVariableInfo getLocalVariableInfo(int slot) {
        if (slot < 0 || slot >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        return this.localVariableInfos[slot];
    }

    public void add(int slot, String name, int startpc, int length, Type t) throws LocalVariableInfoInconsistentException {
        if (slot < 0 || slot >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        this.localVariableInfos[slot].add(name, startpc, length, t);
        if (t == Type.LONG) {
            this.localVariableInfos[slot + 1].add(name, startpc, length, LONG_Upper.theInstance());
        }
        if (t == Type.DOUBLE) {
            this.localVariableInfos[slot + 1].add(name, startpc, length, DOUBLE_Upper.theInstance());
        }
    }
}

