/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactoryObserver;

public class VerifierFactory {
    private static final Map<String, Verifier> hashMap = new HashMap<String, Verifier>();
    private static final List<VerifierFactoryObserver> observers = new Vector<VerifierFactoryObserver>();

    private VerifierFactory() {
    }

    public static Verifier getVerifier(String fullyQualifiedClassName) {
        return VerifierFactory.getVerifier(fullyQualifiedClassName, false);
    }

    public static Verifier getVerifier(byte[] bytecode) {
        return VerifierFactory.getVerifier(bytecode, false);
    }

    public static Verifier getVerifier(String fullyQualifiedClassName, boolean ignoreMissingClasses) {
        Verifier v = hashMap.get(fullyQualifiedClassName);
        if (v == null) {
            v = new Verifier(fullyQualifiedClassName, ignoreMissingClasses);
            hashMap.put(fullyQualifiedClassName, v);
            VerifierFactory.notify(fullyQualifiedClassName);
        }
        return v;
    }

    public static Verifier getVerifier(byte[] bytecode, boolean ignoreMissingClasses) {
        return new Verifier(bytecode, ignoreMissingClasses);
    }

    public static void flush() {
        hashMap.clear();
    }

    private static void notify(String fully_qualified_classname) {
        for (VerifierFactoryObserver vfo : observers) {
            vfo.update(fully_qualified_classname);
        }
    }

    public static Verifier[] getVerifiers() {
        Verifier[] vs = new Verifier[hashMap.values().size()];
        return hashMap.values().toArray(vs);
    }

    public static void attach(VerifierFactoryObserver o) {
        observers.add(o);
    }

    public static void detach(VerifierFactoryObserver o) {
        observers.remove(o);
    }
}

