/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.statics.Pass1Verifier;
import org.apache.bcel.verifier.statics.Pass2Verifier;
import org.apache.bcel.verifier.statics.Pass3aVerifier;
import org.apache.bcel.verifier.structurals.Pass3bVerifier;

public class Verifier {
    private String classname;
    private final byte[] bytecode;
    private Pass1Verifier p1v;
    private Pass2Verifier p2v;
    private final Map<String, Pass3aVerifier> p3avs = new HashMap<String, Pass3aVerifier>();
    private final Map<String, Pass3bVerifier> p3bvs = new HashMap<String, Pass3bVerifier>();
    private final boolean ignoreMissingClasses;

    Verifier(String fullyQualifiedClassName) {
        this(fullyQualifiedClassName, false);
    }

    Verifier(String fullyQualifiedClassName, boolean ignoreMissingClasses) {
        this.classname = fullyQualifiedClassName;
        this.bytecode = null;
        this.ignoreMissingClasses = ignoreMissingClasses;
        this.flush();
    }

    Verifier(byte[] bytecode, boolean ignoreMissingClasses) {
        this.classname = null;
        this.bytecode = bytecode;
        this.ignoreMissingClasses = ignoreMissingClasses;
        this.flush();
    }

    public boolean ignoreMissingClasses() {
        return this.ignoreMissingClasses;
    }

    public VerificationResult doPass1() {
        if (this.p1v == null) {
            this.p1v = new Pass1Verifier(this);
        }
        return this.p1v.verify();
    }

    public VerificationResult doPass2() {
        if (this.p2v == null) {
            this.p2v = new Pass2Verifier(this);
        }
        return this.p2v.verify();
    }

    public VerificationResult doPass3a(int method_no) {
        String key = Integer.toString(method_no);
        Pass3aVerifier p3av = this.p3avs.get(key);
        if (this.p3avs.get(key) == null) {
            p3av = new Pass3aVerifier(this, method_no);
            this.p3avs.put(key, p3av);
        }
        return p3av.verify();
    }

    public VerificationResult doPass3b(int method_no) {
        String key = Integer.toString(method_no);
        Pass3bVerifier p3bv = this.p3bvs.get(key);
        if (this.p3bvs.get(key) == null) {
            p3bv = new Pass3bVerifier(this, method_no);
            this.p3bvs.put(key, p3bv);
        }
        return p3bv.verify();
    }

    public final String getClassName() {
        return this.classname;
    }

    public final void setClassName(String className) {
        this.classname = className;
    }

    public final byte[] getBytecode() {
        return this.bytecode;
    }

    public void flush() {
        this.p1v = null;
        this.p2v = null;
        this.p3avs.clear();
        this.p3bvs.clear();
    }

    public String[] getMessages() throws ClassNotFoundException {
        String element;
        int n;
        int n2;
        String[] stringArray;
        int meth;
        int n3;
        int n4;
        String[] stringArray2;
        ArrayList<String> messages = new ArrayList<String>();
        if (this.p1v != null) {
            String[] stringArray3;
            stringArray2 = stringArray3 = this.p1v.getMessages();
            n4 = stringArray3.length;
            n3 = 0;
            while (n3 < n4) {
                String element2 = stringArray2[n3];
                messages.add("Pass 1: " + element2);
                ++n3;
            }
        }
        if (this.p2v != null) {
            String[] stringArray4 = this.p2v.getMessages();
            stringArray2 = stringArray4;
            n4 = stringArray4.length;
            n3 = 0;
            while (n3 < n4) {
                String element2 = stringArray2[n3];
                messages.add("Pass 2: " + (String)element2);
                ++n3;
            }
        }
        for (Pass3aVerifier pass3aVerifier : this.p3avs.values()) {
            String[] p3am = pass3aVerifier.getMessages();
            meth = pass3aVerifier.getMethodNo();
            stringArray = p3am;
            n2 = p3am.length;
            n = 0;
            while (n < n2) {
                element = stringArray[n];
                messages.add("Pass 3a, method " + meth + " ('" + Repository.lookupClass(this.classname).getMethods()[meth] + "'): " + element);
                ++n;
            }
        }
        for (Pass3bVerifier pass3bVerifier : this.p3bvs.values()) {
            String[] p3bm = pass3bVerifier.getMessages();
            meth = pass3bVerifier.getMethodNo();
            stringArray = p3bm;
            n2 = p3bm.length;
            n = 0;
            while (n < n2) {
                element = stringArray[n];
                messages.add("Pass 3b, method " + meth + " ('" + Repository.lookupClass(this.classname).getMethods()[meth] + "'): " + element);
                ++n;
            }
        }
        String[] stringArray5 = new String[messages.size()];
        int i = 0;
        while (i < messages.size()) {
            stringArray5[i] = (String)messages.get(i);
            ++i;
        }
        return stringArray5;
    }

    public static void main(String[] args) {
        System.out.println("JustIce by Enver Haase, (C) 2001-2002.\n<http://bcel.sourceforge.net>\n<http://commons.apache.org/bcel>\n");
        int k = 0;
        while (k < args.length) {
            try {
                int dotclasspos;
                if (args[k].endsWith(".class") && (dotclasspos = args[k].lastIndexOf(".class")) != -1) {
                    args[k] = args[k].substring(0, dotclasspos);
                }
                args[k] = args[k].replace('/', '.');
                System.out.println("Now verifying: " + args[k] + "\n");
                Verifier v = VerifierFactory.getVerifier(args[k]);
                VerificationResult vr = v.doPass1();
                System.out.println("Pass 1:\n" + vr);
                vr = v.doPass2();
                System.out.println("Pass 2:\n" + vr);
                if (vr == VerificationResult.VR_OK) {
                    JavaClass jc = Repository.lookupClass(args[k]);
                    int i = 0;
                    while (i < jc.getMethods().length) {
                        vr = v.doPass3a(i);
                        System.out.println("Pass 3a, method number " + i + " ['" + jc.getMethods()[i] + "']:\n" + vr);
                        vr = v.doPass3b(i);
                        System.out.println("Pass 3b, method number " + i + " ['" + jc.getMethods()[i] + "']:\n" + vr);
                        ++i;
                    }
                }
                System.out.println("Warnings:");
                String[] warnings = v.getMessages();
                if (warnings.length == 0) {
                    System.out.println("<none>");
                }
                String[] stringArray = warnings;
                int n = warnings.length;
                int n2 = 0;
                while (n2 < n) {
                    String warning = stringArray[n2];
                    System.out.println(warning);
                    ++n2;
                }
                System.out.println("\n");
                v.flush();
                Repository.clearCache();
                System.gc();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ++k;
        }
    }
}

