/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier;

import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.ResolvedField;

public class Resolver {
    public ResolvedField resolveFieldReference(ConstantPoolGen cpg, FieldInstruction instruction) throws ClassNotFoundException {
        String fieldName = instruction.getFieldName(cpg);
        Type fieldType = instruction.getType(cpg);
        JavaClass jc = Repository.lookupClass(instruction.getClassType(cpg).getClassName());
        ResolvedField resolvedField = this.lookForFieldIn(fieldName, fieldType, new JavaClass[]{jc});
        if (resolvedField != null) {
            return resolvedField;
        }
        JavaClass[] superclasses = jc.getSuperClasses();
        resolvedField = this.lookForFieldIn(fieldName, fieldType, superclasses);
        if (resolvedField != null) {
            return resolvedField;
        }
        JavaClass[] interfaces = jc.getAllInterfaces();
        resolvedField = this.lookForFieldIn(fieldName, fieldType, interfaces);
        if (resolvedField != null) {
            return resolvedField;
        }
        return null;
    }

    public ResolvedField lookForFieldIn(String fieldName, Type fieldType, JavaClass[] classes) {
        JavaClass[] javaClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Field[] fields;
            JavaClass clazz = javaClassArray[n2];
            Field[] fieldArray = fields = clazz.getFields();
            int n3 = fields.length;
            int n4 = 0;
            while (n4 < n3) {
                Type f_type;
                Field field = fieldArray[n4];
                if (field.getName().equals(fieldName) && (f_type = Type.getType(field.getSignature())).equals(fieldType)) {
                    return new ResolvedField(field, clazz);
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

