/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;

public class SyntheticRepository
implements Repository {
    private static final long serialVersionUID = 2923440730410019444L;
    private static final Map<ClassPath, SyntheticRepository> _instances = new HashMap<ClassPath, SyntheticRepository>();
    private ClassPath _path = null;
    private final Map<String, SoftReference<JavaClass>> _loadedClasses = new HashMap<String, SoftReference<JavaClass>>();

    private SyntheticRepository(ClassPath path) {
        this._path = path;
    }

    public static SyntheticRepository getInstance() {
        return SyntheticRepository.getInstance(ClassPath.SYSTEM_CLASS_PATH);
    }

    public static SyntheticRepository getInstance(ClassPath classPath) {
        SyntheticRepository rep = _instances.get(classPath);
        if (rep == null) {
            rep = new SyntheticRepository(classPath);
            _instances.put(classPath, rep);
        }
        return rep;
    }

    @Override
    public void storeClass(JavaClass clazz) {
        this._loadedClasses.put(clazz.getClassName(), new SoftReference<JavaClass>(clazz));
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass clazz) {
        this._loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public JavaClass findClass(String className) {
        SoftReference<JavaClass> ref = this._loadedClasses.get(className);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        if (className == null || className.equals("")) {
            throw new IllegalArgumentException("Invalid class name " + className);
        }
        JavaClass clazz = this.findClass(className = className.replace('/', '.'));
        if (clazz != null) {
            return clazz;
        }
        try {
            return this.loadClass(this._path.getInputStream(className), className);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
        }
    }

    @Override
    public JavaClass loadClass(Class<?> clazz) throws ClassNotFoundException {
        String className;
        InputStream clsStream;
        block13: {
            JavaClass javaClass;
            clsStream = null;
            try {
                className = clazz.getName();
                JavaClass repositoryClass = this.findClass(className);
                if (repositoryClass == null) break block13;
                javaClass = repositoryClass;
            }
            catch (Throwable throwable) {
                try {
                    if (clsStream != null) {
                        clsStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (clsStream != null) {
                    clsStream.close();
                }
            }
            catch (IOException iOException) {}
            return javaClass;
        }
        String name = className;
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        clsStream = clazz.getResourceAsStream(String.valueOf(name) + ".class");
        JavaClass javaClass = this.loadClass(clsStream, className);
        try {
            if (clsStream != null) {
                clsStream.close();
            }
        }
        catch (IOException iOException) {}
        return javaClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JavaClass loadClass(InputStream is, String className) throws ClassNotFoundException {
        block10: {
            JavaClass javaClass;
            try {
                if (is == null) break block10;
                ClassParser parser = new ClassParser(is, className);
                JavaClass clazz = parser.parse();
                this.storeClass(clazz);
                javaClass = clazz;
                if (is == null) return javaClass;
            }
            catch (IOException e) {
                try {
                    throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
                }
                catch (Throwable throwable) {
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                is.close();
                return javaClass;
            }
            catch (IOException iOException) {}
            return javaClass;
        }
        if (is == null) throw new ClassNotFoundException("SyntheticRepository could not load " + className);
        try {
            is.close();
            throw new ClassNotFoundException("SyntheticRepository could not load " + className);
        }
        catch (IOException iOException) {}
        throw new ClassNotFoundException("SyntheticRepository could not load " + className);
    }

    @Override
    public ClassPath getClassPath() {
        return this._path;
    }

    @Override
    public void clear() {
        this._loadedClasses.clear();
    }
}

