/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath
implements Serializable {
    private static final long serialVersionUID = 2099441438483340671L;
    public static final ClassPath SYSTEM_CLASS_PATH = new ClassPath();
    private static final FilenameFilter ARCHIVE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return (name = name.toLowerCase(Locale.ENGLISH)).endsWith(".zip") || name.endsWith(".jar");
        }
    };
    private final PathEntry[] paths;
    private final String class_path;
    private ClassPath parent;

    public ClassPath(ClassPath parent, String class_path) {
        this(class_path);
        this.parent = parent;
    }

    public ClassPath(String class_path) {
        this.class_path = class_path;
        ArrayList<PathEntry> vec = new ArrayList<PathEntry>();
        StringTokenizer tok = new StringTokenizer(class_path, System.getProperty("path.separator"));
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            if (path.equals("")) continue;
            File file = new File(path);
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    vec.add(new Dir(path));
                    continue;
                }
                vec.add(new Zip(new ZipFile(file)));
            }
            catch (IOException e) {
                if (!path.endsWith(".zip") && !path.endsWith(".jar")) continue;
                System.err.println("CLASSPATH component " + file + ": " + e);
            }
        }
        this.paths = new PathEntry[vec.size()];
        vec.toArray(this.paths);
    }

    @Deprecated
    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    public String toString() {
        if (this.parent != null) {
            return String.valueOf(this.parent.toString()) + File.pathSeparator + this.class_path;
        }
        return this.class_path;
    }

    public int hashCode() {
        if (this.parent != null) {
            return this.class_path.hashCode() + this.parent.hashCode();
        }
        return this.class_path.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ClassPath) {
            ClassPath cp = (ClassPath)o;
            return this.class_path.equals(cp.toString());
        }
        return false;
    }

    private static void getPathComponents(String path, List<String> list) {
        if (path != null) {
            StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String name = tok.nextToken();
                File file = new File(name);
                if (!file.exists()) continue;
                list.add(name);
            }
        }
    }

    public static String getClassPath() {
        String class_path = System.getProperty("java.class.path");
        String boot_path = System.getProperty("sun.boot.class.path");
        String ext_path = System.getProperty("java.ext.dirs");
        ArrayList<String> list = new ArrayList<String>();
        ClassPath.getPathComponents(class_path, list);
        ClassPath.getPathComponents(boot_path, list);
        ArrayList<String> dirs = new ArrayList<String>();
        ClassPath.getPathComponents(ext_path, dirs);
        for (String d : dirs) {
            File ext_dir = new File(d);
            String[] extensions = ext_dir.list(ARCHIVE_FILTER);
            if (extensions == null) continue;
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                list.add(String.valueOf(ext_dir.getPath()) + File.separatorChar + extension);
                ++n2;
            }
        }
        StringBuilder buf = new StringBuilder();
        String separator = "";
        for (String path : list) {
            buf.append(separator);
            separator = File.pathSeparator;
            buf.append(path);
        }
        return buf.toString().intern();
    }

    public InputStream getInputStream(String name) throws IOException {
        return this.getInputStream(name.replace('.', '/'), ".class");
    }

    public InputStream getInputStream(String name, String suffix) throws IOException {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(String.valueOf(name) + suffix);
        }
        catch (Exception exception) {}
        if (is != null) {
            return is;
        }
        return this.getClassFile(name, suffix).getInputStream();
    }

    public InputStream getResourceAsStream(String name) {
        PathEntry[] pathEntryArray = this.paths;
        int n = this.paths.length;
        int n2 = 0;
        while (n2 < n) {
            PathEntry path = pathEntryArray[n2];
            InputStream is = path.getResourceAsStream(name);
            if (is != null) {
                return is;
            }
            ++n2;
        }
        return null;
    }

    public URL getResource(String name) {
        PathEntry[] pathEntryArray = this.paths;
        int n = this.paths.length;
        int n2 = 0;
        while (n2 < n) {
            PathEntry path = pathEntryArray[n2];
            URL url = path.getResource(name);
            if (url != null) {
                return url;
            }
            ++n2;
        }
        return null;
    }

    public Enumeration<URL> getResources(String name) {
        Vector<URL> results = new Vector<URL>();
        PathEntry[] pathEntryArray = this.paths;
        int n = this.paths.length;
        int n2 = 0;
        while (n2 < n) {
            PathEntry path = pathEntryArray[n2];
            URL url = path.getResource(name);
            if (url != null) {
                results.add(url);
            }
            ++n2;
        }
        return results.elements();
    }

    public ClassFile getClassFile(String name, String suffix) throws IOException {
        ClassFile cf = null;
        if (this.parent != null) {
            cf = this.parent.getClassFileInternal(name, suffix);
        }
        if (cf == null) {
            cf = this.getClassFileInternal(name, suffix);
        }
        if (cf != null) {
            return cf;
        }
        throw new IOException("Couldn't find: " + name + suffix);
    }

    private ClassFile getClassFileInternal(String name, String suffix) throws IOException {
        PathEntry[] pathEntryArray = this.paths;
        int n = this.paths.length;
        int n2 = 0;
        while (n2 < n) {
            PathEntry path = pathEntryArray[n2];
            ClassFile cf = path.getClassFile(name, suffix);
            if (cf != null) {
                return cf;
            }
            ++n2;
        }
        return null;
    }

    public ClassFile getClassFile(String name) throws IOException {
        return this.getClassFile(name, ".class");
    }

    public byte[] getBytes(String name, String suffix) throws IOException {
        try (FilterInputStream dis = null;){
            InputStream is = this.getInputStream(name, suffix);
            if (is == null) {
                throw new IOException("Couldn't find: " + name + suffix);
            }
            dis = new DataInputStream(is);
            byte[] bytes = new byte[is.available()];
            ((DataInputStream)dis).readFully(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public byte[] getBytes(String name) throws IOException {
        return this.getBytes(name, ".class");
    }

    public String getPath(String name) throws IOException {
        int index = name.lastIndexOf(46);
        String suffix = "";
        if (index > 0) {
            suffix = name.substring(index);
            name = name.substring(0, index);
        }
        return this.getPath(name, suffix);
    }

    public String getPath(String name, String suffix) throws IOException {
        return this.getClassFile(name, suffix).getPath();
    }

    public static interface ClassFile {
        public InputStream getInputStream() throws IOException;

        public String getPath();

        public String getBase();

        public long getTime();

        public long getSize();
    }

    private static class Dir
    extends PathEntry {
        private static final long serialVersionUID = 4374062802142373088L;
        private final String dir;

        Dir(String d) {
            this.dir = d;
        }

        @Override
        URL getResource(String name) {
            File file = new File(String.valueOf(this.dir) + File.separatorChar + name.replace('/', File.separatorChar));
            try {
                return file.exists() ? file.toURI().toURL() : null;
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }

        @Override
        InputStream getResourceAsStream(String name) {
            File file = new File(String.valueOf(this.dir) + File.separatorChar + name.replace('/', File.separatorChar));
            try {
                return file.exists() ? new FileInputStream(file) : null;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        ClassFile getClassFile(String name, String suffix) throws IOException {
            final File file = new File(String.valueOf(this.dir) + File.separatorChar + name.replace('.', File.separatorChar) + suffix);
            return file.exists() ? new ClassFile(){

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(file);
                }

                @Override
                public String getPath() {
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }

                @Override
                public long getTime() {
                    return file.lastModified();
                }

                @Override
                public long getSize() {
                    return file.length();
                }

                @Override
                public String getBase() {
                    return Dir.this.dir;
                }
            } : null;
        }

        public String toString() {
            return this.dir;
        }
    }

    private static abstract class PathEntry
    implements Serializable {
        private static final long serialVersionUID = 6828494485207666122L;

        private PathEntry() {
        }

        abstract ClassFile getClassFile(String var1, String var2) throws IOException;

        abstract URL getResource(String var1);

        abstract InputStream getResourceAsStream(String var1);
    }

    private static class Zip
    extends PathEntry {
        private static final long serialVersionUID = -2210747632897905532L;
        private final ZipFile zip;

        Zip(ZipFile z) {
            this.zip = z;
        }

        @Override
        URL getResource(String name) {
            ZipEntry entry = this.zip.getEntry(name);
            try {
                return entry != null ? new URL("jar:file:" + this.zip.getName() + "!/" + name) : null;
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }

        @Override
        InputStream getResourceAsStream(String name) {
            ZipEntry entry = this.zip.getEntry(name);
            try {
                return entry != null ? this.zip.getInputStream(entry) : null;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        ClassFile getClassFile(String name, String suffix) throws IOException {
            final ZipEntry entry = this.zip.getEntry(String.valueOf(name.replace('.', '/')) + suffix);
            if (entry == null) {
                return null;
            }
            return new ClassFile(){

                @Override
                public InputStream getInputStream() throws IOException {
                    return Zip.this.zip.getInputStream(entry);
                }

                @Override
                public String getPath() {
                    return entry.toString();
                }

                @Override
                public long getTime() {
                    return entry.getTime();
                }

                @Override
                public long getSize() {
                    return entry.getSize();
                }

                @Override
                public String getBase() {
                    return Zip.this.zip.getName();
                }
            };
        }
    }
}

